/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental.reactive;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.channels.LinkedListChannel;
import kotlinx.coroutines.experimental.channels.SubscriptionReceiveChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\f\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0014J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\rH\u0014J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0015\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000bH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlinx/coroutines/experimental/reactive/SubscriptionChannel;", "T", "Lkotlinx/coroutines/experimental/channels/LinkedListChannel;", "Lkotlinx/coroutines/experimental/channels/SubscriptionReceiveChannel;", "Lorg/reactivestreams/Subscriber;", "()V", "_balance", "Lkotlinx/atomicfu/AtomicInt;", "get_balance", "()Lkotlinx/atomicfu/AtomicInt;", "subscription", "Lorg/reactivestreams/Subscription;", "afterClose", "", "cause", "", "close", "onCancelledReceive", "onComplete", "onEnqueuedReceive", "onError", "e", "onNext", "t", "(Ljava/lang/Object;)V", "onSubscribe", "s", "kotlinx-coroutines-reactive"})
final class SubscriptionChannel<T>
extends LinkedListChannel<T>
implements SubscriptionReceiveChannel<T>,
Subscriber<T> {
    @JvmField
    @Nullable
    public volatile Subscription subscription;
    volatile int _balance = 0;
    static final AtomicIntegerFieldUpdater _balance$FU = AtomicIntegerFieldUpdater.newUpdater(SubscriptionChannel.class, "_balance");

    protected void onEnqueuedReceive() {
        SubscriptionChannel $receiver$iv = this;
        while (true) {
            int balance = $receiver$iv._balance;
            Subscription subscription = this.subscription;
            if (subscription != null) {
                if (balance < 0) {
                    if (!_balance$FU.compareAndSet(this, balance, 0)) continue;
                    subscription.request(-((long)balance));
                    return;
                }
                if (balance == 0) {
                    subscription.request(1L);
                    return;
                }
            }
            if (_balance$FU.compareAndSet(this, balance, balance - 1)) break;
        }
    }

    protected void onCancelledReceive() {
        _balance$FU.incrementAndGet(this);
    }

    protected void afterClose(@Nullable Throwable cause) {
        block0: {
            Subscription subscription = this.subscription;
            if (subscription == null) break block0;
            subscription.cancel();
        }
    }

    public void close() {
        this.close(null);
    }

    public void onSubscribe(@NotNull Subscription s) {
        int balance;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.subscription = s;
        do {
            if (this.isClosedForSend()) {
                s.cancel();
                return;
            }
            balance = this._balance;
            if (balance < 0) continue;
            return;
        } while (!_balance$FU.compareAndSet(this, balance, 0));
        s.request(-((long)balance));
    }

    public void onNext(T t) {
        this.offer(t);
    }

    public void onComplete() {
        this.close(null);
    }

    public void onError(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.close(e);
    }
}

