/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.reactive;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.LinkedListChannel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SubscriptionReceiveChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000b\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0015\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0014J\b\u0010\u0018\u001a\u00020\u000eH\u0014J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlinx/coroutines/reactive/SubscriptionChannel;", "T", "Lkotlinx/coroutines/channels/LinkedListChannel;", "Lkotlinx/coroutines/channels/ReceiveChannel;", "Lorg/reactivestreams/Subscriber;", "Lkotlinx/coroutines/channels/SubscriptionReceiveChannel;", "request", "", "(I)V", "_requested", "Lkotlinx/atomicfu/AtomicInt;", "subscription", "Lorg/reactivestreams/Subscription;", "afterClose", "", "cause", "", "onComplete", "onError", "e", "onNext", "t", "(Ljava/lang/Object;)V", "onReceiveDequeued", "onReceiveEnqueued", "onSubscribe", "s", "kotlinx-coroutines-reactive"})
final class SubscriptionChannel<T>
extends LinkedListChannel<T>
implements ReceiveChannel<T>,
Subscriber<T>,
SubscriptionReceiveChannel<T> {
    private volatile Subscription subscription;
    private volatile int _requested;
    private static final AtomicIntegerFieldUpdater _requested$FU = AtomicIntegerFieldUpdater.newUpdater(SubscriptionChannel.class, "_requested");
    private final int request;

    protected void onReceiveEnqueued() {
        SubscriptionChannel $receiver$iv = this;
        while (true) {
            int wasRequested = $receiver$iv._requested;
            Subscription subscription = this.subscription;
            int needRequested = wasRequested - 1;
            if (subscription != null && needRequested < 0) {
                if (wasRequested != this.request && !_requested$FU.compareAndSet(this, wasRequested, this.request)) continue;
                subscription.request((long)(this.request - needRequested));
                return;
            }
            if (_requested$FU.compareAndSet(this, wasRequested, needRequested)) break;
        }
    }

    protected void onReceiveDequeued() {
        _requested$FU.incrementAndGet(this);
    }

    protected void afterClose(@Nullable Throwable cause) {
        block0: {
            Subscription subscription = this.subscription;
            if (subscription == null) break block0;
            subscription.cancel();
        }
    }

    public void onSubscribe(@NotNull Subscription s) {
        int wasRequested;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.subscription = s;
        do {
            if (this.isClosedForSend()) {
                s.cancel();
                return;
            }
            wasRequested = this._requested;
            if (wasRequested < this.request) continue;
            return;
        } while (!_requested$FU.compareAndSet(this, wasRequested, this.request));
        s.request((long)(this.request - wasRequested));
    }

    public void onNext(T t) {
        _requested$FU.decrementAndGet(this);
        this.offer(t);
    }

    public void onComplete() {
        this.close(null);
    }

    public void onError(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.close(e);
    }

    public SubscriptionChannel(int request) {
        boolean bl;
        this.request = request;
        boolean bl2 = bl = this.request >= 0;
        if (!bl) {
            String string = "Invalid request size: " + this.request;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this._requested = 0;
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="cancel()"), message="Use `cancel`")
    public void close() {
        SubscriptionReceiveChannel.DefaultImpls.close((SubscriptionReceiveChannel)this);
    }
}

