/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonPrimitiveDecoder;
import kotlinx.serialization.json.internal.JsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonTreeListDecoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a-\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0000\u00a2\u0006\u0002\u0010\f\u001a5\u0010\r\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0000\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"getElementIndexOrThrow", "", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "name", "", "readJson", "T", "Lkotlinx/serialization/json/Json;", "element", "Lkotlinx/serialization/json/JsonElement;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonElement;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "readPolymorphicJson", "discriminator", "Lkotlinx/serialization/json/JsonObject;", "(Lkotlinx/serialization/json/Json;Ljava/lang/String;Lkotlinx/serialization/json/JsonObject;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "kotlinx-serialization-json"})
public final class TreeJsonDecoderKt {
    public static final <T> T readJson(@NotNull Json $this$readJson, @NotNull JsonElement element, @NotNull DeserializationStrategy<T> deserializer) {
        AbstractJsonTreeDecoder abstractJsonTreeDecoder;
        Intrinsics.checkNotNullParameter((Object)$this$readJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        JsonElement jsonElement = element;
        if (jsonElement instanceof JsonObject) {
            abstractJsonTreeDecoder = new JsonTreeDecoder($this$readJson, (JsonObject)element, null, null, 12, null);
        } else if (jsonElement instanceof JsonArray) {
            abstractJsonTreeDecoder = new JsonTreeListDecoder($this$readJson, (JsonArray)element);
        } else if (jsonElement instanceof JsonLiteral ? true : Intrinsics.areEqual((Object)jsonElement, (Object)JsonNull.INSTANCE)) {
            abstractJsonTreeDecoder = new JsonPrimitiveDecoder($this$readJson, (JsonPrimitive)element);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        AbstractJsonTreeDecoder input = abstractJsonTreeDecoder;
        return input.decodeSerializableValue(deserializer);
    }

    public static final <T> T readPolymorphicJson(@NotNull Json $this$readPolymorphicJson, @NotNull String discriminator, @NotNull JsonObject element, @NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkNotNullParameter((Object)$this$readPolymorphicJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)discriminator, (String)"discriminator");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return new JsonTreeDecoder($this$readPolymorphicJson, element, discriminator, deserializer.getDescriptor()).decodeSerializableValue(deserializer);
    }

    public static final int getElementIndexOrThrow(@NotNull SerialDescriptor $this$getElementIndexOrThrow, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$getElementIndexOrThrow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int index = $this$getElementIndexOrThrow.getElementIndex(name);
        if (index == -3) {
            throw new SerializationException($this$getElementIndexOrThrow.getSerialName() + " does not contain element with name '" + name + '\'');
        }
        return index;
    }
}

