/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0001\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0014J\b\u0010\u001d\u001a\u00020\u001eH&J\u0006\u0010\u001f\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0004H\u0003J\u0006\u0010!\u001a\u00020\u001eJ\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\b\u0010$\u001a\u00020\rH&J\b\u0010%\u001a\u00020&H&J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0016J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\rJ \u0010+\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0005J\u0006\u0010,\u001a\u00020\rJ\u0006\u0010-\u001a\u00020\rJ\u0018\u0010.\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004H&J\b\u00101\u001a\u00020\u001aH\u0016J\u0006\u00102\u001a\u00020\u001aJ\u0010\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020&H\u0004J\u0018\u00103\u001a\u0002052\u0006\u00106\u001a\u00020\r2\b\b\u0002\u00100\u001a\u00020\u0004J\u000e\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\rJ\u0018\u00109\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0010\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020(H\u0004J\u0006\u0010>\u001a\u00020&J\u0010\u0010?\u001a\u0004\u0018\u00010\r2\u0006\u0010@\u001a\u00020\u001eJ1\u0010A\u001a\u00020\u001a2\u0006\u0010B\u001a\u00020\u001e2\b\b\u0002\u00100\u001a\u00020\u00042\f\u00106\u001a\b\u0012\u0004\u0012\u00020\r0CH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\bDJ\u000e\u0010E\u001a\u00020\u001a2\u0006\u0010F\u001a\u00020\u001eJ\b\u0010G\u001a\u00020\u0004H\u0016J\u0018\u0010H\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u0004H\u0016J\b\u0010J\u001a\u00020\rH\u0002J\b\u0010K\u001a\u00020\rH\u0016J\b\u0010L\u001a\u00020\u001eH&J\u0006\u0010M\u001a\u00020\u001eJ\u0010\u0010N\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0004J\b\u0010O\u001a\u00020\u001eH\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006P"}, d2={"Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "", "()V", "currentPosition", "", "escapedString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getEscapedString", "()Ljava/lang/StringBuilder;", "setEscapedString", "(Ljava/lang/StringBuilder;)V", "peekedString", "", "source", "", "getSource", "()Ljava/lang/CharSequence;", "appendEsc", "startPosition", "appendEscape", "lastPosition", "current", "appendHex", "startPos", "appendRange", "", "fromIndex", "toIndex", "canConsumeValue", "", "consumeBoolean", "start", "consumeBooleanLenient", "consumeBooleanLiteral", "literalSuffix", "consumeKeyString", "consumeNextToken", "", "expected", "", "consumeNumericLiteral", "", "consumeString", "consumeStringLenient", "consumeStringLenientNotNull", "decodedString", "definitelyNotEof", "position", "ensureHaveChars", "expectEof", "fail", "expectedToken", "", "message", "failOnUnknownKey", "key", "fromHexChar", "indexOf", "char", "isValidValueStart", "c", "peekNextToken", "peekString", "isLenient", "require", "condition", "Lkotlin/Function0;", "require$kotlinx_serialization_json", "skipElement", "allowLenientStrings", "skipWhitespaces", "substring", "endPos", "takePeeked", "toString", "tryConsumeComma", "tryConsumeNotNull", "unexpectedToken", "wasUnquotedString", "kotlinx-serialization-json"})
public abstract class AbstractJsonLexer {
    @JvmField
    protected int currentPosition;
    @Nullable
    private String peekedString;
    @NotNull
    private StringBuilder escapedString = new StringBuilder();

    @NotNull
    protected abstract CharSequence getSource();

    public void ensureHaveChars() {
    }

    public abstract int definitelyNotEof(int var1);

    public abstract boolean tryConsumeComma();

    public abstract boolean canConsumeValue();

    public abstract byte consumeNextToken();

    protected final boolean isValidValueStart(char c) {
        char c2 = c;
        return !(((c2 == '}' ? true : c2 == ']') ? true : c2 == ':') ? true : c2 == ',');
    }

    public final void expectEof() {
        byte nextToken = this.consumeNextToken();
        if (nextToken != 10) {
            AbstractJsonLexer.fail$default(this, "Expected EOF after parsing an object, but had " + this.getSource().charAt(this.currentPosition - 1) + " instead", 0, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    protected final StringBuilder getEscapedString() {
        return this.escapedString;
    }

    protected final void setEscapedString(@NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"<set-?>");
        this.escapedString = stringBuilder;
    }

    public final byte consumeNextToken(byte expected) {
        byte token = this.consumeNextToken();
        if (token != expected) {
            this.fail(expected);
        }
        return token;
    }

    public void consumeNextToken(char expected) {
        this.ensureHaveChars();
        CharSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.definitelyNotEof(cpos)) != -1) {
            int n = cpos;
            cpos = n + 1;
            char c = source.charAt(n);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            this.currentPosition = cpos;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.currentPosition = cpos;
        this.unexpectedToken(expected);
    }

    protected final void unexpectedToken(char expected) {
        AbstractJsonLexer abstractJsonLexer = this;
        abstractJsonLexer.currentPosition += -1;
        int cfr_ignored_0 = abstractJsonLexer.currentPosition;
        if (expected == '\"' && Intrinsics.areEqual((Object)this.consumeStringLenient(), (Object)"null")) {
            this.fail("Expected string literal but 'null' literal was found.\nUse 'coerceInputValues = true' in 'Json {}` builder to coerce nulls to default values.", this.currentPosition - 4);
            throw new KotlinNothingValueException();
        }
        this.fail(AbstractJsonLexerKt.charToTokenClass(expected));
    }

    protected final void fail(byte expectedToken) {
        byte by = expectedToken;
        String expected = by == 1 ? "quotation mark '\"'" : (by == 4 ? "comma ','" : (by == 5 ? "semicolon ':'" : (by == 6 ? "start of the object '{'" : (by == 7 ? "end of the object '}'" : (by == 8 ? "start of the array '['" : (by == 9 ? "end of the array ']'" : "valid token"))))));
        String s = this.currentPosition == this.getSource().length() || this.currentPosition <= 0 ? "EOF" : String.valueOf(this.getSource().charAt(this.currentPosition - 1));
        this.fail("Expected " + expected + ", but had '" + s + "' instead", this.currentPosition - 1);
        throw new KotlinNothingValueException();
    }

    public final byte peekNextToken() {
        CharSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.definitelyNotEof(cpos)) != -1) {
            char ch = source.charAt(cpos);
            if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t') {
                ++cpos;
                continue;
            }
            this.currentPosition = cpos;
            return AbstractJsonLexerKt.charToTokenClass(ch);
        }
        this.currentPosition = cpos;
        return 10;
    }

    public final boolean tryConsumeNotNull() {
        int current = this.skipWhitespaces();
        current = this.definitelyNotEof(current);
        int len = this.getSource().length() - current;
        if (len < 4 || current == -1) {
            return true;
        }
        int n = 0;
        do {
            int i;
            if ("null".charAt(i = n++) == this.getSource().charAt(current + i)) continue;
            return true;
        } while (n <= 3);
        if (len > 4 && AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current + 4)) == 0) {
            return true;
        }
        this.currentPosition = current + 4;
        return false;
    }

    public int skipWhitespaces() {
        char c;
        int current = this.currentPosition;
        while ((current = this.definitelyNotEof(current)) != -1 && ((c = this.getSource().charAt(current)) == ' ' || c == '\n' || c == '\r' || c == '\t')) {
            ++current;
        }
        this.currentPosition = current;
        return current;
    }

    @Nullable
    public final String peekString(boolean isLenient) {
        String string;
        String string2;
        byte token = this.peekNextToken();
        if (isLenient) {
            if (token != 1 && token != 0) {
                return null;
            }
            string2 = this.consumeStringLenient();
        } else {
            if (token != 1) {
                return null;
            }
            string2 = this.consumeString();
        }
        this.peekedString = string = string2;
        return string;
    }

    public int indexOf(char c, int startPos) {
        return StringsKt.indexOf$default((CharSequence)this.getSource(), (char)c, (int)startPos, (boolean)false, (int)4, null);
    }

    @NotNull
    public String substring(int startPos, int endPos) {
        CharSequence charSequence = this.getSource();
        boolean bl = false;
        return ((Object)charSequence.subSequence(startPos, endPos)).toString();
    }

    @NotNull
    public abstract String consumeKeyString();

    @NotNull
    public final String consumeString() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        return this.consumeKeyString();
    }

    @NotNull
    protected final String consumeString(@NotNull CharSequence source, int startPosition, int current) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int currentPosition = current;
        int lastPosition = startPosition;
        char c = source.charAt(currentPosition);
        boolean usedAppend = false;
        while (c != '\"') {
            if (c == '\\') {
                usedAppend = true;
                lastPosition = currentPosition = this.appendEscape(lastPosition, currentPosition);
            } else if (++currentPosition >= source.length()) {
                usedAppend = true;
                this.appendRange(lastPosition, currentPosition);
                currentPosition = this.definitelyNotEof(currentPosition);
                if (currentPosition == -1) {
                    this.fail("EOF", currentPosition);
                    throw new KotlinNothingValueException();
                }
                lastPosition = currentPosition;
            }
            c = source.charAt(currentPosition);
        }
        String string = !usedAppend ? this.substring(lastPosition, currentPosition) : this.decodedString(lastPosition, currentPosition);
        this.currentPosition = currentPosition + 1;
        return string;
    }

    private final int appendEscape(int lastPosition, int current) {
        this.appendRange(lastPosition, current);
        return this.appendEsc(current + 1);
    }

    private final String decodedString(int lastPosition, int currentPosition) {
        this.appendRange(lastPosition, currentPosition);
        String string = this.escapedString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapedString.toString()");
        String result = string;
        this.escapedString.setLength(0);
        return result;
    }

    private final String takePeeked() {
        String string = this.peekedString;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        this.peekedString = null;
        return string2;
    }

    @NotNull
    public final String consumeStringLenientNotNull() {
        String result = this.consumeStringLenient();
        if (Intrinsics.areEqual((Object)result, (Object)"null") && this.wasUnquotedString()) {
            AbstractJsonLexer.fail$default(this, "Unexpected 'null' value instead of string literal", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return result;
    }

    private final boolean wasUnquotedString() {
        return this.getSource().charAt(this.currentPosition - 1) != '\"';
    }

    @NotNull
    public final String consumeStringLenient() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            this.fail("EOF", current);
            throw new KotlinNothingValueException();
        }
        byte token = AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current));
        if (token == 1) {
            return this.consumeString();
        }
        if (token != 0) {
            AbstractJsonLexer.fail$default(this, Intrinsics.stringPlus((String)"Expected beginning of the string, but got ", (Object)Character.valueOf(this.getSource().charAt(current))), 0, 2, null);
            throw new KotlinNothingValueException();
        }
        boolean usedAppend = false;
        while (AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current)) == 0) {
            if (++current < this.getSource().length()) continue;
            usedAppend = true;
            this.appendRange(this.currentPosition, current);
            int eof = this.definitelyNotEof(current);
            if (eof == -1) {
                this.currentPosition = current;
                return this.decodedString(0, 0);
            }
            current = eof;
        }
        String result = !usedAppend ? this.substring(this.currentPosition, current) : this.decodedString(this.currentPosition, current);
        this.currentPosition = current;
        return result;
    }

    protected void appendRange(int fromIndex, int toIndex) {
        this.escapedString.append(this.getSource(), fromIndex, toIndex);
    }

    private final int appendEsc(int startPosition) {
        int currentPosition = startPosition;
        if ((currentPosition = this.definitelyNotEof(currentPosition)) == -1) {
            AbstractJsonLexer.fail$default(this, "Expected escape sequence to continue, got EOF", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        int n = currentPosition;
        currentPosition = n + 1;
        char currentChar = this.getSource().charAt(n);
        if (currentChar == 'u') {
            return this.appendHex(this.getSource(), currentPosition);
        }
        char c = currentChar;
        boolean bl = false;
        char c2 = AbstractJsonLexerKt.escapeToChar(c);
        if (c2 == '\u0000') {
            AbstractJsonLexer.fail$default(this, "Invalid escaped char '" + currentChar + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        this.escapedString.append(c2);
        return currentPosition;
    }

    private final int appendHex(CharSequence source, int startPos) {
        if (startPos + 4 >= source.length()) {
            AbstractJsonLexer.fail$default(this, "Unexpected EOF during unicode escape", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        this.escapedString.append((char)((this.fromHexChar(source, startPos) << 12) + (this.fromHexChar(source, startPos + 1) << 8) + (this.fromHexChar(source, startPos + 2) << 4) + this.fromHexChar(source, startPos + 3)));
        return startPos + 4;
    }

    public final void require$kotlinx_serialization_json(boolean condition, int position, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition) {
            this.fail((String)message.invoke(), position);
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void require$kotlinx_serialization_json$default(AbstractJsonLexer this_, boolean condition, int position, Function0 message, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: require");
        }
        if ((n & 2) != 0) {
            position = this_.currentPosition;
        }
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition) {
            this_.fail((String)message.invoke(), position);
            throw new KotlinNothingValueException();
        }
    }

    private final int fromHexChar(CharSequence source, int currentPosition) {
        int n;
        int character = source.charAt(currentPosition);
        boolean bl = 48 <= character ? character <= 57 : false;
        if (bl) {
            int n2 = character;
            boolean bl2 = false;
            int n3 = n2;
            n2 = 48;
            bl2 = false;
            n = n3 - n2;
        } else {
            boolean bl3 = 97 <= character ? character <= 102 : false;
            if (bl3) {
                int n4 = character;
                boolean bl4 = false;
                int n5 = n4;
                n4 = 97;
                bl4 = false;
                n = n5 - n4 + 10;
            } else {
                boolean bl5 = 65 <= character ? character <= 70 : false;
                if (bl5) {
                    int n6 = character;
                    boolean bl6 = false;
                    int n7 = n6;
                    n6 = 65;
                    bl6 = false;
                    n = n7 - n6 + 10;
                } else {
                    AbstractJsonLexer.fail$default(this, "Invalid toHexChar char '" + (char)character + "' in unicode escape", 0, 2, null);
                    throw new KotlinNothingValueException();
                }
            }
        }
        return n;
    }

    public final void skipElement(boolean allowLenientStrings) {
        boolean bl = false;
        List tokenStack = new ArrayList();
        byte lastToken = this.peekNextToken();
        if (lastToken != 8 && lastToken != 6) {
            this.consumeStringLenient();
            return;
        }
        while (true) {
            if ((lastToken = this.peekNextToken()) == 1) {
                if (allowLenientStrings) {
                    this.consumeStringLenient();
                    continue;
                }
                this.consumeKeyString();
                continue;
            }
            byte by = lastToken;
            if (by == 8 ? true : by == 6) {
                tokenStack.add(lastToken);
            } else if (by == 9) {
                if (((Number)CollectionsKt.last((List)tokenStack)).byteValue() != 8) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found ] instead of }", this.getSource());
                }
                CollectionsKt.removeLast((List)tokenStack);
            } else if (by == 7) {
                if (((Number)CollectionsKt.last((List)tokenStack)).byteValue() != 6) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found } instead of ]", this.getSource());
                }
                CollectionsKt.removeLast((List)tokenStack);
            } else if (by == 10) {
                AbstractJsonLexer.fail$default(this, "Unexpected end of input due to malformed JSON during ignoring unknown keys", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            this.consumeNextToken();
            if (tokenStack.size() == 0) break;
        }
    }

    @NotNull
    public String toString() {
        return "JsonReader(source='" + this.getSource() + "', currentPosition=" + this.currentPosition + ')';
    }

    public final void failOnUnknownKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String processed = this.substring(0, this.currentPosition);
        int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)processed, (String)key, (int)0, (boolean)false, (int)6, null);
        this.fail("Encountered an unknown key '" + key + "'.\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.", lastIndexOf);
        throw new KotlinNothingValueException();
    }

    @NotNull
    public final Void fail(@NotNull String message, int position) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw JsonExceptionsKt.JsonDecodingException(position, message, this.getSource());
    }

    public static /* synthetic */ Void fail$default(AbstractJsonLexer abstractJsonLexer, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fail");
        }
        if ((n2 & 2) != 0) {
            n = abstractJsonLexer.currentPosition;
        }
        return abstractJsonLexer.fail(string, n);
    }

    public final long consumeNumericLiteral() {
        long l;
        boolean bl;
        int current = this.skipWhitespaces();
        if ((current = this.definitelyNotEof(current)) >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current) == '\"') {
            if (++current == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        long accumulator = 0L;
        boolean isNegative = false;
        int start = current;
        boolean hasChars = true;
        while (hasChars) {
            char ch = this.getSource().charAt(current);
            if (ch == '-') {
                if (current != start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '-' in numeric literal", 0, 2, null);
                    throw new KotlinNothingValueException();
                }
                isNegative = true;
                ++current;
                continue;
            }
            byte token = AbstractJsonLexerKt.charToTokenClass(ch);
            if (token != 0) break;
            hasChars = ++current != this.getSource().length();
            int digit = ch - 48;
            if (!(0 <= digit ? digit <= 9 : false)) {
                AbstractJsonLexer.fail$default(this, "Unexpected symbol '" + ch + "' in numeric literal", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            if ((accumulator = accumulator * (long)10 - (long)digit) <= 0L) continue;
            AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (start == current || isNegative && start == current - 1) {
            AbstractJsonLexer.fail$default(this, "Expected numeric literal", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (hasQuotation) {
            if (!hasChars) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(current) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            ++current;
        }
        this.currentPosition = current;
        if (isNegative) {
            l = accumulator;
        } else if (accumulator != Long.MIN_VALUE) {
            l = -accumulator;
        } else {
            AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return l;
    }

    public final boolean consumeBoolean() {
        return this.consumeBoolean(this.skipWhitespaces());
    }

    public final boolean consumeBooleanLenient() {
        boolean bl;
        int current = this.skipWhitespaces();
        if (current == this.getSource().length()) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current) == '\"') {
            ++current;
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        boolean result = this.consumeBoolean(current);
        if (hasQuotation) {
            if (this.currentPosition == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(this.currentPosition) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            AbstractJsonLexer abstractJsonLexer = this;
            ++abstractJsonLexer.currentPosition;
            int cfr_ignored_0 = abstractJsonLexer.currentPosition;
        }
        return result;
    }

    private final boolean consumeBoolean(int start) {
        boolean bl;
        int current = this.definitelyNotEof(start);
        if (current >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        int n = current;
        current = n + 1;
        n = this.getSource().charAt(n);
        boolean bl2 = false;
        int n2 = n | 0x20;
        n = 116;
        bl2 = false;
        if (n2 == n) {
            this.consumeBooleanLiteral("rue", current);
            bl = true;
        } else {
            n = 102;
            bl2 = false;
            if (n2 == n) {
                this.consumeBooleanLiteral("alse", current);
                bl = false;
            } else {
                AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, 2, null);
                throw new KotlinNothingValueException();
            }
        }
        return bl;
    }

    private final void consumeBooleanLiteral(String literalSuffix, int current) {
        if (this.getSource().length() - current < literalSuffix.length()) {
            AbstractJsonLexer.fail$default(this, "Unexpected end of boolean literal", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        int n = 0;
        int n2 = literalSuffix.length() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                char expected = literalSuffix.charAt(i);
                char actual = this.getSource().charAt(current + i);
                char c = expected;
                boolean bl = false;
                char c2 = c;
                c = actual;
                bl = false;
                if (c2 == (c | 0x20)) continue;
                AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, 2, null);
                throw new KotlinNothingValueException();
            } while (n <= n2);
        }
        this.currentPosition = current + literalSuffix.length();
    }
}

