/*
 * Decompiled with CFR 0.152.
 */
package org.minidns;

import java.io.IOException;
import org.minidns.dnsmessage.DNSMessage;

public abstract class MiniDNSException
extends IOException {
    private static final long serialVersionUID = 1L;

    protected MiniDNSException(String message) {
        super(message);
    }

    public static class NullResultException
    extends MiniDNSException {
        private static final long serialVersionUID = 1L;
        private final DNSMessage request;

        public NullResultException(DNSMessage request) {
            super("The request yielded a 'null' result while resolving.");
            this.request = request;
        }

        public DNSMessage getRequest() {
            return this.request;
        }
    }

    public static class IdMismatch
    extends MiniDNSException {
        private static final long serialVersionUID = 1L;
        private final DNSMessage request;
        private final DNSMessage response;

        public IdMismatch(DNSMessage request, DNSMessage response) {
            super(IdMismatch.getString(request, response));
            assert (request.id != response.id);
            this.request = request;
            this.response = response;
        }

        public DNSMessage getRequest() {
            return this.request;
        }

        public DNSMessage getResponse() {
            return this.response;
        }

        private static String getString(DNSMessage request, DNSMessage response) {
            return "The response's ID doesn't matches the request ID. Request: " + request.id + ". Response: " + response.id;
        }
    }
}

