/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.source;

import java.io.IOException;
import java.net.InetAddress;
import org.minidns.DNSCache;
import org.minidns.MiniDnsFuture;
import org.minidns.dnsmessage.DNSMessage;

public abstract class DNSDataSource {
    protected int udpPayloadSize = 1024;
    protected int timeout = 5000;
    private DNSCache cache;
    private QueryMode queryMode = QueryMode.dontCare;

    public abstract DNSMessage query(DNSMessage var1, InetAddress var2, int var3) throws IOException;

    public MiniDnsFuture<DNSMessage, IOException> queryAsync(DNSMessage message, InetAddress address, int port, OnResponseCallback onResponseCallback) {
        DNSMessage result;
        MiniDnsFuture.InternalMiniDnsFuture<DNSMessage, IOException> future = new MiniDnsFuture.InternalMiniDnsFuture<DNSMessage, IOException>();
        try {
            result = this.query(message, address, port);
        }
        catch (IOException e) {
            future.setException(e);
            return future;
        }
        future.setResult(result);
        return future;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout must be greater than zero");
        }
        this.timeout = timeout;
    }

    public int getUdpPayloadSize() {
        return this.udpPayloadSize;
    }

    public void setUdpPayloadSize(int udpPayloadSize) {
        if (udpPayloadSize <= 0) {
            throw new IllegalArgumentException("UDP payload size must be greater than zero");
        }
        this.udpPayloadSize = udpPayloadSize;
    }

    protected final void cacheResult(DNSMessage request, DNSMessage response) {
        DNSCache activeCache = this.cache;
        if (activeCache == null) {
            return;
        }
        activeCache.put(request, response);
    }

    public void setQueryMode(QueryMode queryMode) {
        if (queryMode == null) {
            throw new IllegalArgumentException();
        }
        this.queryMode = queryMode;
    }

    public QueryMode getQueryMode() {
        return this.queryMode;
    }

    public static interface OnResponseCallback {
        public void onResponse(DNSMessage var1, DNSMessage var2);
    }

    public static enum QueryMode {
        dontCare,
        udpTcp,
        tcp;

    }
}

