/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.source;

import java.io.IOException;
import java.net.InetAddress;
import org.minidns.DnsCache;
import org.minidns.MiniDnsFuture;
import org.minidns.dnsmessage.DnsMessage;

public abstract class DnsDataSource {
    protected int udpPayloadSize = 1024;
    protected int timeout = 5000;
    private DnsCache cache;
    private QueryMode queryMode = QueryMode.dontCare;

    public abstract DnsMessage query(DnsMessage var1, InetAddress var2, int var3) throws IOException;

    public MiniDnsFuture<DnsMessage, IOException> queryAsync(DnsMessage message, InetAddress address, int port, OnResponseCallback onResponseCallback) {
        DnsMessage result;
        MiniDnsFuture.InternalMiniDnsFuture<DnsMessage, IOException> future = new MiniDnsFuture.InternalMiniDnsFuture<DnsMessage, IOException>();
        try {
            result = this.query(message, address, port);
        }
        catch (IOException e) {
            future.setException(e);
            return future;
        }
        future.setResult(result);
        return future;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout must be greater than zero");
        }
        this.timeout = timeout;
    }

    public int getUdpPayloadSize() {
        return this.udpPayloadSize;
    }

    public void setUdpPayloadSize(int udpPayloadSize) {
        if (udpPayloadSize <= 0) {
            throw new IllegalArgumentException("UDP payload size must be greater than zero");
        }
        this.udpPayloadSize = udpPayloadSize;
    }

    protected final void cacheResult(DnsMessage request, DnsMessage response) {
        DnsCache activeCache = this.cache;
        if (activeCache == null) {
            return;
        }
        activeCache.put(request, response);
    }

    public void setQueryMode(QueryMode queryMode) {
        if (queryMode == null) {
            throw new IllegalArgumentException();
        }
        this.queryMode = queryMode;
    }

    public QueryMode getQueryMode() {
        return this.queryMode;
    }

    public static interface OnResponseCallback {
        public void onResponse(DnsMessage var1, DnsMessage var2);
    }

    public static enum QueryMode {
        dontCare,
        udpTcp,
        tcp;

    }
}

