/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec;

import java.io.IOException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class DnssecValidationFailedException
extends IOException {
    private static final long serialVersionUID = 5413184667629832742L;

    public DnssecValidationFailedException(Question question, String reason) {
        super("Validation of request to " + question + " failed: " + reason);
    }

    public DnssecValidationFailedException(String message) {
        super(message);
    }

    public DnssecValidationFailedException(String message, Throwable cause) {
        super(message, cause);
    }

    public DnssecValidationFailedException(Record<? extends Data> record, String reason) {
        super("Validation of record " + record + " failed: " + reason);
    }

    public DnssecValidationFailedException(List<Record<? extends Data>> records, String reason) {
        super("Validation of " + records.size() + " " + records.get((int)0).type + " record" + (records.size() > 1 ? "s" : "") + " failed: " + reason);
    }

    public static class AuthorityDoesNotContainSoa
    extends DnssecValidationFailedException {
        private static final long serialVersionUID = 1L;
        private final DnsMessage response;

        public AuthorityDoesNotContainSoa(DnsMessage response) {
            super("Autority does not contain SOA");
            this.response = response;
        }

        public DnsMessage getResponse() {
            return this.response;
        }
    }

    public static class DnssecInvalidKeySpecException
    extends DnssecValidationFailedException {
        private static final long serialVersionUID = 1L;

        public DnssecInvalidKeySpecException(InvalidKeySpecException exception) {
            super("Invalid key spec", exception);
        }

        public DnssecInvalidKeySpecException(String message, InvalidKeySpecException exception, byte[] data) {
            super(message, exception);
        }
    }

    public static class DataMalformedException
    extends DnssecValidationFailedException {
        private static final long serialVersionUID = 1L;
        private final byte[] data;

        public DataMalformedException(IOException exception, byte[] data) {
            super("Malformed data", exception);
            this.data = data;
        }

        public DataMalformedException(String message, IOException exception, byte[] data) {
            super(message, exception);
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

