/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec.algorithms;

import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.algorithms.JavaSecSignatureVerifier;
import org.minidns.record.DNSKEY;
import org.minidns.record.RRSIG;

class EcgostSignatureVerifier
extends JavaSecSignatureVerifier {
    private static final int LENGTH = 32;
    private static final ECParameterSpec SPEC = new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD97", 16)), new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD94", 16), new BigInteger("A6", 16)), new ECPoint(BigInteger.ONE, new BigInteger("8D91E471E0989CDA27DF505A453F2B7635294F2DDF23E3B122ACC99C9E9F1E14", 16)), new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF6C611070995AD10045841B09B761B893", 16), 1);

    public EcgostSignatureVerifier() throws NoSuchAlgorithmException {
        super("ECGOST3410", "GOST3411withECGOST3410");
    }

    @Override
    protected byte[] getSignature(RRSIG rrsig) {
        return rrsig.getSignature();
    }

    @Override
    protected PublicKey getPublicKey(DNSKEY key) throws DnssecValidationFailedException.DataMalformedException, DnssecValidationFailedException.DnssecInvalidKeySpecException {
        BigInteger y;
        BigInteger x;
        DataInputStream dis = key.getKeyAsDataInputStream();
        try {
            byte[] xBytes = new byte[32];
            dis.readFully(xBytes);
            EcgostSignatureVerifier.reverse(xBytes);
            x = new BigInteger(1, xBytes);
            byte[] yBytes = new byte[32];
            dis.readFully(yBytes);
            EcgostSignatureVerifier.reverse(yBytes);
            y = new BigInteger(1, yBytes);
        }
        catch (IOException e) {
            throw new DnssecValidationFailedException.DataMalformedException(e, key.getKey());
        }
        try {
            return this.getKeyFactory().generatePublic(new ECPublicKeySpec(new ECPoint(x, y), SPEC));
        }
        catch (InvalidKeySpecException e) {
            throw new DnssecValidationFailedException.DnssecInvalidKeySpecException(e);
        }
    }

    private static void reverse(byte[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            int j = array.length - i - 1;
            byte tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }
}

