/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec.algorithms;

import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.algorithms.JavaSecSignatureVerifier;
import org.minidns.record.DNSKEY;
import org.minidns.record.RRSIG;

class RsaSignatureVerifier
extends JavaSecSignatureVerifier {
    RsaSignatureVerifier(String algorithm) throws NoSuchAlgorithmException {
        super("RSA", algorithm);
    }

    @Override
    protected PublicKey getPublicKey(DNSKEY key) throws DnssecValidationFailedException.DataMalformedException, DnssecValidationFailedException.DnssecInvalidKeySpecException {
        BigInteger modulus;
        BigInteger exponent;
        DataInputStream dis = key.getKeyAsDataInputStream();
        try {
            int exponentLength = dis.readUnsignedByte();
            int bytesRead = 1;
            if (exponentLength == 0) {
                bytesRead += 2;
                exponentLength = dis.readUnsignedShort();
            }
            byte[] exponentBytes = new byte[exponentLength];
            dis.readFully(exponentBytes);
            exponent = new BigInteger(1, exponentBytes);
            byte[] modulusBytes = new byte[key.getKeyLength() - (bytesRead += exponentLength)];
            dis.readFully(modulusBytes);
            modulus = new BigInteger(1, modulusBytes);
        }
        catch (IOException e) {
            throw new DnssecValidationFailedException.DataMalformedException(e, key.getKey());
        }
        try {
            return this.getKeyFactory().generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (InvalidKeySpecException e) {
            throw new DnssecValidationFailedException.DnssecInvalidKeySpecException(e);
        }
    }

    @Override
    protected byte[] getSignature(RRSIG rrsig) {
        return rrsig.getSignature();
    }
}

