/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.hla;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.minidns.AbstractDnsClient;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.hla.ResolverResult;
import org.minidns.hla.SrvProto;
import org.minidns.hla.SrvResolverResult;
import org.minidns.hla.SrvService;
import org.minidns.hla.SrvType;
import org.minidns.iterative.ReliableDnsClient;
import org.minidns.record.Data;
import org.minidns.record.PTR;
import org.minidns.record.Record;
import org.minidns.record.SRV;
import org.minidns.util.InetAddressUtil;

public class ResolverApi {
    public static final ResolverApi INSTANCE = new ResolverApi((AbstractDnsClient)new ReliableDnsClient());
    private final AbstractDnsClient dnsClient;

    public ResolverApi(AbstractDnsClient dnsClient) {
        this.dnsClient = dnsClient;
    }

    public final <D extends Data> ResolverResult<D> resolve(String name, Class<D> type) throws IOException {
        return this.resolve(DnsName.from((String)name), type);
    }

    public final <D extends Data> ResolverResult<D> resolve(DnsName name, Class<D> type) throws IOException {
        Record.TYPE t = Record.TYPE.getType(type);
        Question q = new Question(name, t);
        return this.resolve(q);
    }

    public <D extends Data> ResolverResult<D> resolve(Question question) throws IOException {
        DnsMessage dnsMessage = this.dnsClient.query(question);
        return new ResolverResult(question, dnsMessage, null);
    }

    public SrvResolverResult resolveSrv(SrvType type, String serviceName) throws IOException {
        return this.resolveSrv(type.service, type.proto, DnsName.from((String)serviceName));
    }

    public SrvResolverResult resolveSrv(SrvType type, DnsName serviceName) throws IOException {
        return this.resolveSrv(type.service, type.proto, serviceName);
    }

    public SrvResolverResult resolveSrv(SrvService service, SrvProto proto, String name) throws IOException {
        return this.resolveSrv(service.dnsName, proto.dnsName, DnsName.from((String)name));
    }

    public SrvResolverResult resolveSrv(SrvService service, SrvProto proto, DnsName name) throws IOException {
        return this.resolveSrv(service.dnsName, proto.dnsName, name);
    }

    public SrvResolverResult resolveSrv(DnsName service, DnsName proto, DnsName name) throws IOException {
        DnsName srvRrName = DnsName.from((DnsName[])new DnsName[]{service, proto, name});
        return this.resolveSrv(srvRrName);
    }

    public SrvResolverResult resolveSrv(String name) throws IOException {
        return this.resolveSrv(DnsName.from((String)name));
    }

    public ResolverResult<PTR> reverseLookup(CharSequence inetAddressCs) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(inetAddressCs.toString());
        return this.reverseLookup(inetAddress);
    }

    public ResolverResult<PTR> reverseLookup(InetAddress inetAddress) throws IOException {
        if (inetAddress instanceof Inet4Address) {
            return this.reverseLookup((Inet4Address)inetAddress);
        }
        if (inetAddress instanceof Inet6Address) {
            return this.reverseLookup((Inet6Address)inetAddress);
        }
        throw new IllegalArgumentException("The given InetAddress '" + inetAddress + "' is neither of type Inet4Address or Inet6Address");
    }

    public ResolverResult<PTR> reverseLookup(Inet4Address inet4Address) throws IOException {
        DnsName reversedIpAddress = InetAddressUtil.reverseIpAddressOf((Inet4Address)inet4Address);
        DnsName dnsName = DnsName.from((DnsName)reversedIpAddress, (DnsName)DnsName.IN_ADDR_ARPA);
        return this.resolve(dnsName, PTR.class);
    }

    public ResolverResult<PTR> reverseLookup(Inet6Address inet6Address) throws IOException {
        DnsName reversedIpAddress = InetAddressUtil.reverseIpAddressOf((Inet6Address)inet6Address);
        DnsName dnsName = DnsName.from((DnsName)reversedIpAddress, (DnsName)DnsName.IP6_ARPA);
        return this.resolve(dnsName, PTR.class);
    }

    public SrvResolverResult resolveSrv(DnsName name) throws IOException {
        ResolverResult<SRV> result = this.resolve(name, SRV.class);
        return new SrvResolverResult(result, this);
    }

    public final AbstractDnsClient getClient() {
        return this.dnsClient;
    }
}

