/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.iterative;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.iterative.IterativeClientException;
import org.minidns.iterative.IterativeDnsClient;

public class ResolutionState {
    private final IterativeDnsClient recursiveDnsClient;
    private final HashMap<InetAddress, Set<Question>> map = new HashMap();
    private int steps;

    ResolutionState(IterativeDnsClient recursiveDnsClient) {
        this.recursiveDnsClient = recursiveDnsClient;
    }

    void recurse(InetAddress address, DnsMessage query) throws IterativeClientException.LoopDetected, IterativeClientException.MaxIterativeStepsReached {
        Question question = query.getQuestion();
        if (!this.map.containsKey(address)) {
            this.map.put(address, new HashSet());
        } else if (this.map.get(address).contains(question)) {
            throw new IterativeClientException.LoopDetected();
        }
        if (++this.steps > this.recursiveDnsClient.maxSteps) {
            throw new IterativeClientException.MaxIterativeStepsReached();
        }
        boolean isNew = this.map.get(address).add(question);
        assert (isNew);
    }

    void decrementSteps() {
        --this.steps;
    }
}

