/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.StringUtil;
import org.mockito.plugins.AnnotationEngine;
import org.mockito.plugins.MemberAccessor;

public class SpyAnnotationEngine
implements AnnotationEngine,
org.mockito.configuration.AnnotationEngine {
    @Override
    public AutoCloseable process(Class<?> context, Object testInstance) {
        Field[] fields = context.getDeclaredFields();
        MemberAccessor accessor = Plugins.getMemberAccessor();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Spy.class) || field.isAnnotationPresent(InjectMocks.class)) continue;
            SpyAnnotationEngine.assertNoIncompatibleAnnotations(Spy.class, field, Mock.class, Captor.class);
            try {
                Object instance = accessor.get(field, testInstance);
                if (MockUtil.isMock(instance)) {
                    Mockito.reset(instance);
                    continue;
                }
                if (instance != null) {
                    accessor.set(field, testInstance, SpyAnnotationEngine.spyInstance(field, instance));
                    continue;
                }
                accessor.set(field, testInstance, SpyAnnotationEngine.spyNewInstance(testInstance, field));
            }
            catch (Exception e) {
                throw new MockitoException("Unable to initialize @Spy annotated field '" + field.getName() + "'.\n" + e.getMessage(), e);
            }
        }
        return new AnnotationEngine.NoAction();
    }

    private static Object spyInstance(Field field, Object instance) {
        return Mockito.mock(instance.getClass(), Mockito.withSettings().spiedInstance(instance).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName()));
    }

    private static Object spyNewInstance(Object testInstance, Field field) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        MockSettings settings = Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName());
        Class<?> type = field.getType();
        if (type.isInterface()) {
            return Mockito.mock(type, settings.useConstructor(new Object[0]));
        }
        int modifiers = type.getModifiers();
        if (SpyAnnotationEngine.typeIsPrivateAbstractInnerClass(type, modifiers)) {
            throw new MockitoException(StringUtil.join("@Spy annotation can't initialize private abstract inner classes.", "  inner class: '" + type.getSimpleName() + "'", "  outer class: '" + type.getEnclosingClass().getSimpleName() + "'", "", "You should augment the visibility of this inner class"));
        }
        if (SpyAnnotationEngine.typeIsNonStaticInnerClass(type, modifiers)) {
            Class<?> enclosing = type.getEnclosingClass();
            if (!enclosing.isInstance(testInstance)) {
                throw new MockitoException(StringUtil.join("@Spy annotation can only initialize inner classes declared in the test.", "  inner class: '" + type.getSimpleName() + "'", "  outer class: '" + enclosing.getSimpleName() + "'", ""));
            }
            return Mockito.mock(type, settings.useConstructor(new Object[0]).outerInstance(testInstance));
        }
        Constructor<?> constructor = SpyAnnotationEngine.noArgConstructorOf(type);
        if (Modifier.isPrivate(constructor.getModifiers())) {
            MemberAccessor accessor = Plugins.getMemberAccessor();
            return Mockito.mock(type, settings.spiedInstance(accessor.newInstance(constructor, new Object[0])));
        }
        return Mockito.mock(type, settings.useConstructor(new Object[0]));
    }

    private static Constructor<?> noArgConstructorOf(Class<?> type) {
        Constructor<?> constructor;
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MockitoException("Please ensure that the type '" + type.getSimpleName() + "' has a no-arg constructor.");
        }
        return constructor;
    }

    private static boolean typeIsNonStaticInnerClass(Class<?> type, int modifiers) {
        return !Modifier.isStatic(modifiers) && type.getEnclosingClass() != null;
    }

    private static boolean typeIsPrivateAbstractInnerClass(Class<?> type, int modifiers) {
        return Modifier.isPrivate(modifiers) && Modifier.isAbstract(modifiers) && type.getEnclosingClass() != null;
    }

    private static void assertNoIncompatibleAnnotations(Class<? extends Annotation> annotation, Field field, Class<? extends Annotation> ... undesiredAnnotations) {
        for (Class<? extends Annotation> u : undesiredAnnotations) {
            if (!field.isAnnotationPresent(u)) continue;
            throw Reporter.unsupportedCombinationOfAnnotations(annotation.getSimpleName(), u.getSimpleName());
        }
    }
}

