/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.UUID;
import org.mp4parser.Box;
import org.mp4parser.IsoFile;
import org.mp4parser.boxes.iso14496.part12.OriginalFormatBox;
import org.mp4parser.boxes.iso14496.part12.ProtectionSchemeInformationBox;
import org.mp4parser.boxes.iso14496.part12.SchemeInformationBox;
import org.mp4parser.boxes.iso14496.part12.SchemeTypeBox;
import org.mp4parser.boxes.iso23001.part7.TrackEncryptionBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.sampleentry.VisualSampleEntry;
import org.mp4parser.tools.ByteBufferByteChannel;

public class CencEncryptingSampleEntryTransformer {
    private HashMap<SampleEntry, SampleEntry> cache = new HashMap();

    public SampleEntry transform(SampleEntry se, String encryptionAlgo, UUID defaultKeyId) {
        SampleEntry encSampleEntry = this.cache.get(se);
        if (encSampleEntry == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                se.getBox(Channels.newChannel(baos));
                encSampleEntry = (SampleEntry)new IsoFile((ReadableByteChannel)new ByteBufferByteChannel(ByteBuffer.wrap(baos.toByteArray()))).getBoxes().get(0);
            }
            catch (IOException e) {
                throw new RuntimeException("Dumping stsd to memory failed");
            }
            OriginalFormatBox originalFormatBox = new OriginalFormatBox();
            originalFormatBox.setDataFormat(se.getType());
            ProtectionSchemeInformationBox sinf = new ProtectionSchemeInformationBox();
            sinf.addBox((Box)originalFormatBox);
            SchemeTypeBox schm = new SchemeTypeBox();
            schm.setSchemeType(encryptionAlgo);
            schm.setSchemeVersion(65536);
            sinf.addBox((Box)schm);
            SchemeInformationBox schi = new SchemeInformationBox();
            TrackEncryptionBox trackEncryptionBox = new TrackEncryptionBox();
            trackEncryptionBox.setDefaultIvSize(8);
            trackEncryptionBox.setDefaultAlgorithmId(1);
            trackEncryptionBox.setDefault_KID(defaultKeyId);
            schi.addBox((Box)trackEncryptionBox);
            sinf.addBox((Box)schi);
            if (se instanceof AudioSampleEntry) {
                ((AudioSampleEntry)encSampleEntry).setType("enca");
                ((AudioSampleEntry)encSampleEntry).addBox((Box)sinf);
            } else if (se instanceof VisualSampleEntry) {
                ((VisualSampleEntry)encSampleEntry).setType("encv");
                ((VisualSampleEntry)encSampleEntry).addBox((Box)sinf);
            } else {
                throw new RuntimeException("I don't know how to cenc " + se.getType());
            }
            this.cache.put(se, encSampleEntry);
        }
        return encSampleEntry;
    }
}

