/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image;

import org.nothings.stb.image.ColorComponents;
import org.nothings.stb.image.decoding.BmpDecoder;
import org.nothings.stb.image.decoding.GifDecoder;
import org.nothings.stb.image.decoding.JpgDecoder;
import org.nothings.stb.image.decoding.PngDecoder;
import org.nothings.stb.image.decoding.PsdDecoder;
import org.nothings.stb.image.decoding.TgaDecoder;

public class ImageInfo {
    private int width;
    private int height;
    private ColorComponents colorComponents;
    private int bitsPerChannel;

    public ImageInfo(int width, int height, ColorComponents colorComponents, int bitsPerChannel) {
        this.width = width;
        this.height = height;
        this.colorComponents = colorComponents;
        this.bitsPerChannel = bitsPerChannel;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ColorComponents getColorComponents() {
        return this.colorComponents;
    }

    public int getBitsPerChannel() {
        return this.bitsPerChannel;
    }

    public static ImageInfo FromInputStream(byte[] data) {
        ImageInfo info = JpgDecoder.Info(data);
        if (info != null) {
            return info;
        }
        info = PngDecoder.Info(data);
        if (info != null) {
            return info;
        }
        info = GifDecoder.Info(data);
        if (info != null) {
            return info;
        }
        info = BmpDecoder.Info(data);
        if (info != null) {
            return info;
        }
        info = PsdDecoder.Info(data);
        if (info != null) {
            return info;
        }
        info = TgaDecoder.Info(data);
        if (info != null) {
            return info;
        }
        return null;
    }
}

