/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image.decoding;

import java.util.Arrays;

public class FakePtrInt {
    private int[] array;
    public int offset;

    public FakePtrInt(FakePtrInt ptr, int offset) {
        this.array = ptr.array;
        this.offset = ptr.offset + offset;
    }

    public FakePtrInt(int[] data, int offset) {
        this.array = data;
        this.offset = offset;
    }

    public FakePtrInt(int[] data) {
        this(data, 0);
    }

    public void clear(int count) {
        Arrays.fill(this.array, this.offset, this.offset + count, 0);
    }

    public int get() {
        return this.array[this.offset];
    }

    public void set(int value) {
        this.array[this.offset] = value;
    }

    public int getAt(int offset) {
        return this.array[this.offset + offset];
    }

    public void setAt(int offset, int value) {
        this.array[this.offset + offset] = value;
    }

    public void move(int offset) {
        this.offset += offset;
    }

    public void increase() {
        this.move(1);
    }

    public int getAndIncrease() {
        int result = this.array[this.offset];
        ++this.offset;
        return result;
    }

    public void setAndIncrease(int value) {
        this.array[this.offset] = value;
        ++this.offset;
    }

    public FakePtrInt cloneAdd(int offset) {
        return new FakePtrInt(this.array, this.offset + offset);
    }

    public FakePtrInt clone() {
        return new FakePtrInt(this.array, this.offset);
    }

    public void fill(int value, int count) {
        Arrays.fill(this.array, this.offset, this.offset + count, value);
    }

    public void memcpy(FakePtrInt b, int count) {
        System.arraycopy(b.array, b.offset, this.array, this.offset, count);
    }
}

