/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image.decoding;

import java.util.Arrays;

class FakePtrShort {
    private short[] array;
    public int offset;

    public FakePtrShort(FakePtrShort ptr, int offset) {
        this.array = ptr.array;
        this.offset = ptr.offset + offset;
    }

    public FakePtrShort(short[] data, int offset) {
        this.array = data;
        this.offset = offset;
    }

    public FakePtrShort(short[] data) {
        this(data, 0);
    }

    public void clear(int count) {
        Arrays.fill(this.array, this.offset, this.offset + count, (short)0);
    }

    public short get() {
        return this.array[this.offset];
    }

    public void set(short value) {
        this.array[this.offset] = value;
    }

    public short getAt(int offset) {
        return this.array[this.offset + offset];
    }

    public void setAt(int offset, short value) {
        this.array[this.offset + offset] = value;
    }

    public void move(int offset) {
        this.offset += offset;
    }

    public void increase() {
        this.move(1);
    }

    public short getAndIncrease() {
        short result = this.array[this.offset];
        ++this.offset;
        return result;
    }

    public void setAndIncrease(short value) {
        this.array[this.offset] = value;
        ++this.offset;
    }

    public FakePtrShort cloneAdd(int offset) {
        return new FakePtrShort(this.array, this.offset + offset);
    }

    public FakePtrShort clone() {
        return new FakePtrShort(this.array, this.offset);
    }

    public void fill(short value, int count) {
        Arrays.fill(this.array, this.offset, this.offset + count, value);
    }

    public void memcpy(FakePtrShort b, int count) {
        System.arraycopy(b.array, b.offset, this.array, this.offset, count);
    }
}

