/*
 * Decompiled with CFR 0.152.
 */
package org.nothings.stb.image.decoding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.nothings.stb.image.ColorComponents;
import org.nothings.stb.image.ImageInfo;
import org.nothings.stb.image.ImageResult;
import org.nothings.stb.image.decoding.Decoder;
import org.nothings.stb.image.decoding.FakePtrByte;
import org.nothings.stb.image.decoding.Pair;
import org.nothings.stb.image.decoding.Utility;

public class GifDecoder
extends Decoder {
    private int w;
    private int h;
    private byte[] _out_;
    private byte[] background;
    private short[] history;
    private int flags;
    private int bgindex;
    private int ratio;
    private int transparent;
    private int eflags;
    private int delay;
    private final byte[] pal;
    private final byte[] lpal;
    private final stbi__gif_lzw[] codes = new stbi__gif_lzw[8192];
    private byte[] color_table;
    private int parse;
    private int step;
    private int lflags;
    private int start_x;
    private int start_y;
    private int max_x;
    private int max_y;
    private int cur_x;
    private int cur_y;
    private int line_size;

    private GifDecoder(InputStream stream) {
        super(stream);
        for (int i = 0; i < this.codes.length; ++i) {
            this.codes[i] = new stbi__gif_lzw();
        }
        this.pal = new byte[1024];
        this.lpal = new byte[1024];
    }

    private void stbi__gif_parse_colortable(byte[] pal, int num_entries, int transp) throws Exception {
        for (int i = 0; i < num_entries; ++i) {
            pal[i * 4 + 2] = (byte)this.stbi__get8();
            pal[i * 4 + 1] = (byte)this.stbi__get8();
            pal[i * 4] = (byte)this.stbi__get8();
            pal[i * 4 + 3] = (byte)(transp == i ? 0 : 255);
        }
    }

    private int stbi__gif_header(int is_info) throws Exception {
        short version = 0;
        if (this.stbi__get8() != 71 || this.stbi__get8() != 73 || this.stbi__get8() != 70 || this.stbi__get8() != 56) {
            GifDecoder.stbi__err("not GIF");
        }
        if ((version = this.stbi__get8()) != 55 && version != 57) {
            GifDecoder.stbi__err("not GIF");
        }
        if (this.stbi__get8() != 97) {
            GifDecoder.stbi__err("not GIF");
        }
        this.w = this.stbi__get16le();
        this.h = this.stbi__get16le();
        this.flags = this.stbi__get8();
        this.bgindex = this.stbi__get8();
        this.ratio = this.stbi__get8();
        this.transparent = -1;
        int comp = 4;
        if (is_info != 0) {
            return comp;
        }
        if ((this.flags & 0x80) != 0) {
            this.stbi__gif_parse_colortable(this.pal, 2 << (this.flags & 7), -1);
        }
        return comp;
    }

    private void stbi__out_gif_code(int code) {
        int idx = 0;
        if (this.codes[code].prefix >= 0) {
            this.stbi__out_gif_code(this.codes[code].prefix);
        }
        if (this.cur_y >= this.max_y) {
            return;
        }
        idx = this.cur_x + this.cur_y;
        this.history[idx / 4] = 1;
        FakePtrByte c = new FakePtrByte(this.color_table, this.codes[code].suffix * 4);
        if (c.getAt(3) > 128) {
            FakePtrByte p = new FakePtrByte(this._out_, idx);
            p.setAt(0, c.getAt(2));
            p.setAt(1, c.getAt(1));
            p.setAt(2, c.getAt(0));
            p.setAt(3, c.getAt(3));
        }
        this.cur_x += 4;
        if (this.cur_x >= this.max_x) {
            this.cur_x = this.start_x;
            this.cur_y += this.step;
            while (this.cur_y >= this.max_y && this.parse > 0) {
                this.step = (1 << this.parse) * this.line_size;
                this.cur_y = this.start_y + (this.step >> 1);
                --this.parse;
            }
        }
    }

    private byte[] stbi__process_gif_raster() throws Exception {
        short lzw_cs = 0;
        int len = 0;
        int init_code = 0;
        long first = 0L;
        int codesize = 0;
        int codemask = 0;
        int avail = 0;
        int oldcode = 0;
        int bits = 0;
        int valid_bits = 0;
        int clear = 0;
        lzw_cs = this.stbi__get8();
        if (lzw_cs > 12) {
            return null;
        }
        clear = 1 << lzw_cs;
        first = 1L;
        codesize = lzw_cs + 1;
        codemask = (1 << codesize) - 1;
        bits = 0;
        valid_bits = 0;
        for (init_code = 0; init_code < clear; ++init_code) {
            this.codes[init_code].prefix = (short)-1;
            this.codes[init_code].first = (short)init_code;
            this.codes[init_code].suffix = (short)init_code;
        }
        avail = clear + 2;
        oldcode = -1;
        len = 0;
        while (true) {
            if (valid_bits < codesize) {
                if (len == 0 && (len = (int)this.stbi__get8()) == 0) {
                    return this._out_;
                }
                --len;
                bits |= this.stbi__get8() << valid_bits;
                valid_bits += 8;
                continue;
            }
            int code = bits & codemask;
            bits >>= codesize;
            valid_bits -= codesize;
            if (code == clear) {
                codesize = lzw_cs + 1;
                codemask = (1 << codesize) - 1;
                avail = clear + 2;
                oldcode = -1;
                first = 0L;
                continue;
            }
            if (code == clear + 1) {
                this.stbi__skip(len);
                while (true) {
                    short s = this.stbi__get8();
                    len = s;
                    if (s <= 0) break;
                    this.stbi__skip(len);
                }
                return this._out_;
            }
            if (code <= avail) {
                if (first != 0L) {
                    GifDecoder.stbi__err("no clear code");
                }
                if (oldcode >= 0) {
                    int idx = avail++;
                    if (avail > 8192) {
                        GifDecoder.stbi__err("too many codes");
                    }
                    this.codes[idx].prefix = (short)oldcode;
                    this.codes[idx].first = this.codes[oldcode].first;
                    this.codes[idx].suffix = code == avail ? this.codes[idx].first : this.codes[code].first;
                } else if (code == avail) {
                    GifDecoder.stbi__err("illegal code in raster");
                }
                this.stbi__out_gif_code(code);
                if ((avail & codemask) == 0 && avail <= 4095) {
                    codemask = (1 << ++codesize) - 1;
                }
                oldcode = code;
                continue;
            }
            GifDecoder.stbi__err("illegal code in raster");
        }
    }

    private Pair<byte[], Integer> stbi__gif_load_next(FakePtrByte two_back) throws Exception {
        int dispose = 0;
        boolean first_frame = false;
        int pi = 0;
        int pcount = 0;
        first_frame = false;
        int comp = 0;
        if (this._out_ == null) {
            comp = this.stbi__gif_header(0);
            if (comp == 0) {
                return null;
            }
            pcount = this.w * this.h;
            this._out_ = new byte[4 * pcount];
            Arrays.fill(this._out_, (byte)0);
            this.background = new byte[4 * pcount];
            Arrays.fill(this.background, (byte)0);
            this.history = new short[pcount];
            Arrays.fill(this.history, (short)0);
            first_frame = true;
        } else {
            FakePtrByte ptr = new FakePtrByte(this._out_);
            dispose = (this.eflags & 0x1C) >> 2;
            pcount = this.w * this.h;
            if (dispose == 3 && two_back == null) {
                dispose = 2;
            }
            if (dispose == 3) {
                for (pi = 0; pi < pcount; ++pi) {
                    if (this.history[pi] == 0) continue;
                    new FakePtrByte(ptr, pi * 4).memcpy(new FakePtrByte(two_back, pi * 4), 4);
                }
            } else if (dispose == 2) {
                for (pi = 0; pi < pcount; ++pi) {
                    if (this.history[pi] == 0) continue;
                    new FakePtrByte(ptr, pi * 4).memcpy(new FakePtrByte(this.background, pi * 4), 4);
                }
            }
            new FakePtrByte(this.background).memcpy(ptr, 4 * this.w * this.h);
        }
        Arrays.fill(this.history, 0, this.w * this.h, (short)0);
        block7: while (true) {
            short tag = this.stbi__get8();
            switch (tag) {
                case 44: {
                    int x = 0;
                    int y = 0;
                    int w = 0;
                    int h = 0;
                    x = this.stbi__get16le();
                    y = this.stbi__get16le();
                    w = this.stbi__get16le();
                    h = this.stbi__get16le();
                    if (x + w > w || y + h > h) {
                        GifDecoder.stbi__err("bad Image Descriptor");
                    }
                    this.line_size = w * 4;
                    this.start_x = x * 4;
                    this.start_y = y * this.line_size;
                    this.max_x = this.start_x + w * 4;
                    this.max_y = this.start_y + h * this.line_size;
                    this.cur_x = this.start_x;
                    this.cur_y = this.start_y;
                    if (w == 0) {
                        this.cur_y = this.max_y;
                    }
                    this.lflags = this.stbi__get8();
                    if ((this.lflags & 0x40) != 0) {
                        this.step = 8 * this.line_size;
                        this.parse = 3;
                    } else {
                        this.step = this.line_size;
                        this.parse = 0;
                    }
                    if ((this.lflags & 0x80) != 0) {
                        this.stbi__gif_parse_colortable(this.lpal, 2 << (this.lflags & 7), (this.eflags & 1) != 0 ? this.transparent : -1);
                        this.color_table = this.lpal;
                    } else if ((this.flags & 0x80) != 0) {
                        this.color_table = this.pal;
                    } else {
                        GifDecoder.stbi__err("missing color table");
                    }
                    byte[] o = this.stbi__process_gif_raster();
                    if (o == null) {
                        return null;
                    }
                    pcount = w * h;
                    if (first_frame && this.bgindex > 0) {
                        for (pi = 0; pi < pcount; ++pi) {
                            if (this.history[pi] != 0) continue;
                            this.pal[this.bgindex * 4 + 3] = -1;
                            new FakePtrByte(this._out_, pi * 4).memcpy(new FakePtrByte(this.pal, this.bgindex), 4);
                        }
                    }
                    return new Pair<byte[], Integer>(o, comp);
                }
                case 33: {
                    short len = 0;
                    short ext = this.stbi__get8();
                    if (ext == 249) {
                        len = this.stbi__get8();
                        if (len == 4) {
                            this.eflags = this.stbi__get8();
                            this.delay = 10 * this.stbi__get16le();
                            if (this.transparent >= 0) {
                                this.pal[this.transparent * 4 + 3] = -1;
                            }
                            if ((this.eflags & 1) != 0) {
                                this.transparent = this.stbi__get8();
                                if (this.transparent >= 0) {
                                    this.pal[this.transparent * 4 + 3] = 0;
                                }
                            } else {
                                this.stbi__skip(1);
                                this.transparent = -1;
                            }
                        } else {
                            this.stbi__skip(len);
                            continue block7;
                        }
                    }
                    while (true) {
                        if ((len = this.stbi__get8()) == 0) continue block7;
                        this.stbi__skip(len);
                    }
                }
                case 59: {
                    return null;
                }
            }
            GifDecoder.stbi__err("unknown code");
        }
    }

    private ImageResult InternalDecode(ColorComponents requiredComponents) throws Exception {
        Pair<byte[], Integer> u = this.stbi__gif_load_next(null);
        if (u == null) {
            throw new Exception("could not decode gif");
        }
        byte[] data = (byte[])u.first;
        if (requiredComponents != null && requiredComponents != ColorComponents.RedGreenBlueAlpha) {
            data = Utility.stbi__convert_format(data, 4, ColorComponents.toReqComp(requiredComponents), this.w, this.h);
        }
        return new ImageResult(this.w, this.h, ColorComponents.fromInt((Integer)u.second), requiredComponents != null ? requiredComponents : ColorComponents.fromInt((Integer)u.second), 8, data);
    }

    private static boolean InternalTest(InputStream stream) throws Exception {
        short sz = 0;
        if (Utility.stbi__get8(stream) != 71 || Utility.stbi__get8(stream) != 73 || Utility.stbi__get8(stream) != 70 || Utility.stbi__get8(stream) != 56) {
            return false;
        }
        sz = Utility.stbi__get8(stream);
        if (sz != 57 && sz != 55) {
            return false;
        }
        return Utility.stbi__get8(stream) == 97;
    }

    public static boolean Test(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            return GifDecoder.InternalTest(stream);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static ImageInfo Info(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            GifDecoder decoder = new GifDecoder(stream);
            int comp = decoder.stbi__gif_header(1);
            if (comp == 0) {
                return null;
            }
            return new ImageInfo(decoder.w, decoder.h, ColorComponents.fromInt(comp), 8);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ImageResult Decode(byte[] data, ColorComponents requiredComponents) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        GifDecoder decoder = new GifDecoder(stream);
        return decoder.InternalDecode(requiredComponents);
    }

    public static ImageResult Decode(byte[] data) throws Exception {
        return GifDecoder.Decode(data, null);
    }

    private static class stbi__gif_lzw {
        public short prefix;
        public short first;
        public short suffix;

        private stbi__gif_lzw() {
        }
    }
}

