/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BidirectionalMap<K, V>
implements Map<K, V> {
    private Map<K, V> aKeyToValueMap;
    private Map<V, K> aValueToKeyMap;

    public BidirectionalMap() {
        this.aKeyToValueMap = new HashMap();
        this.aValueToKeyMap = new HashMap<V, K>();
    }

    public BidirectionalMap(Class<? extends Map<K, V>> rKeyToValueMapType, Class<? extends Map<V, K>> rValueToKeyMapType) {
        try {
            this.aKeyToValueMap = rKeyToValueMapType.newInstance();
            this.aValueToKeyMap = rValueToKeyMapType.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid map class", e);
        }
    }

    @Override
    public void clear() {
        this.aKeyToValueMap.clear();
        this.aValueToKeyMap.clear();
    }

    @Override
    public boolean containsKey(Object rKey) {
        return this.aKeyToValueMap.containsKey(rKey);
    }

    @Override
    public boolean containsValue(Object rValue) {
        return this.aValueToKeyMap.containsKey(rValue);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.aKeyToValueMap.entrySet();
    }

    @Override
    public V get(Object rKey) {
        return this.aKeyToValueMap.get(rKey);
    }

    public K getKey(Object rValue) {
        return this.aValueToKeyMap.get(rValue);
    }

    @Override
    public boolean isEmpty() {
        return this.aKeyToValueMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.aKeyToValueMap.keySet();
    }

    @Override
    public V put(K rKey, V rValue) {
        K rReplacedKey;
        V rReplacedValue = this.aKeyToValueMap.put(rKey, rValue);
        if (rReplacedValue != null) {
            this.aValueToKeyMap.remove(rReplacedValue);
        }
        if ((rReplacedKey = this.aValueToKeyMap.put(rValue, rKey)) != null) {
            this.aKeyToValueMap.remove(rReplacedKey);
            if (rReplacedValue == null) {
                rReplacedValue = rValue;
            }
        }
        return rReplacedValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> rMap) {
        for (Map.Entry<K, V> e : rMap.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object rKey) {
        V rRemoved = this.aKeyToValueMap.remove(rKey);
        if (rRemoved != null) {
            this.aValueToKeyMap.remove(rRemoved);
        }
        return rRemoved;
    }

    public Set<Map.Entry<V, K>> reverseEntrySet() {
        return this.aValueToKeyMap.entrySet();
    }

    @Override
    public int size() {
        return this.aKeyToValueMap.size();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.aKeyToValueMap + "," + this.aValueToKeyMap + "]";
    }

    @Override
    public Collection<V> values() {
        return this.aValueToKeyMap.keySet();
    }
}

