/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.datatype;

import de.esoco.lib.expression.Conversions;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;

public class Period
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Period NONE = new Period();
    public static final Period HOURLY = new Period(1, Unit.HOUR);
    public static final Period DAYLY = new Period(1, Unit.DAY);
    public static final Period WEEKLY = new Period(1, Unit.WEEK);
    public static final Period MONTHLY = new Period(1, Unit.MONTH);
    public static final Period QUARTERLY = new Period(3, Unit.MONTH);
    public static final Period HALF_YEARLY = new Period(6, Unit.MONTH);
    public static final Period YEARLY = new Period(1, Unit.YEAR);
    private int nCount;
    private Unit eUnit;

    public Period(int nCount, Unit eUnit) {
        if (nCount <= 0 || eUnit == Unit.NONE) {
            throw new IllegalArgumentException("Invalid period parameters: " + nCount + "," + (Object)((Object)eUnit));
        }
        this.nCount = nCount;
        this.eUnit = eUnit;
    }

    private Period() {
        this.nCount = 0;
        this.eUnit = Unit.NONE;
    }

    public static Period valueOf(String sPeriod) {
        Period rResult;
        if (Unit.NONE.name().equals(sPeriod)) {
            rResult = NONE;
        } else {
            String[] rParts = sPeriod.split("\\.");
            if (rParts.length != 2) {
                throw new IllegalArgumentException("Invalid period string: " + sPeriod);
            }
            try {
                int nCount = Integer.parseInt(rParts[0]);
                Unit eUnit = Unit.valueOf(rParts[1]);
                rResult = eUnit != Unit.NONE ? new Period(nCount, eUnit) : NONE;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unparseable period string: " + sPeriod, e);
            }
        }
        return rResult;
    }

    public Date endDate(Date rStartDate) {
        return this.eUnit.calculateDate(rStartDate, this.nCount, -1);
    }

    public boolean equals(Object rObject) {
        if (this == rObject) {
            return true;
        }
        if (rObject == null || this.getClass() != rObject.getClass()) {
            return false;
        }
        Period rOther = (Period)rObject;
        return this.eUnit == rOther.eUnit && this.nCount == rOther.nCount;
    }

    public final int getCount() {
        return this.nCount;
    }

    public final Unit getUnit() {
        return this.eUnit;
    }

    public int hashCode() {
        return 31 * (this.eUnit == null ? 0 : this.eUnit.hashCode()) + this.nCount;
    }

    public Date nextDate(Date rDate) {
        return this.eUnit.calculateDate(rDate, this.nCount, 0);
    }

    public Date previousDate(Date rDate) {
        return this.eUnit.calculateDate(rDate, -this.nCount, 0);
    }

    public Date startDate(Date rEndDate) {
        return this.eUnit.calculateDate(rEndDate, -this.nCount, 1);
    }

    public String toString() {
        return this.eUnit != Unit.NONE ? this.nCount + "." + (Object)((Object)this.eUnit) : Unit.NONE.name();
    }

    protected void setCount(int rCount) {
        this.nCount = rCount;
    }

    protected void setUnit(Unit rUnit) {
        this.eUnit = rUnit;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.eUnit == Unit.NONE ? NONE : this;
    }

    static {
        Conversions.registerStringConversion(Period.class, new Conversions.StringConversion<Period>(Period.class){

            @Override
            public Period invert(String sValue) {
                return Period.valueOf(sValue);
            }
        });
    }

    public static enum Unit {
        MILLISECOND(14, 1L),
        SECOND(13, 1000L),
        MINUTE(12, 60000L),
        HOUR(11, 3600000L),
        DAY(5, 86400000L),
        WEEK(3, 604800000L),
        MONTH(2, 2592000000L),
        YEAR(1, 1471228928L),
        NONE(-1, -1L){

            @Override
            public Date calculateDate(Date rDate, int nFieldAdd, int nDayAdd) {
                return null;
            }
        };

        public static Set<Unit> TIME_UNITS;
        public static Set<Unit> DATE_UNITS;
        private final int nCalendarField;
        private long nMilliseconds;

        private Unit(int nCalendarField, long nMilliseconds) {
            this.nCalendarField = nCalendarField;
            this.nMilliseconds = nMilliseconds;
        }

        public Date calculateDate(Date rDate, int nFieldAdd, int nDayAdd) {
            Calendar rCalendar = Calendar.getInstance();
            rCalendar.setTime(rDate);
            rCalendar.add(this.nCalendarField, nFieldAdd);
            if (nDayAdd != 0 && DATE_UNITS.contains((Object)this)) {
                rCalendar.add(5, nDayAdd);
            }
            return rCalendar.getTime();
        }

        public int getCalendarField() {
            return this.nCalendarField;
        }

        public long getMilliseconds() {
            return this.nMilliseconds;
        }

        static {
            TIME_UNITS = EnumSet.of(MILLISECOND, SECOND, MINUTE, HOUR);
            DATE_UNITS = EnumSet.of(DAY, WEEK, MONTH, YEAR);
        }
    }
}

