/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.event;

import de.esoco.lib.event.Event;
import de.esoco.lib.event.EventHandler;

public class EventMulticaster<E extends Event<?>>
implements EventHandler<E> {
    private EventHandler<E> rFirst;
    private EventHandler<E> rSecond;

    public EventMulticaster(EventHandler<E> rFirst, EventHandler<E> rSecond) {
        this.rFirst = rFirst;
        this.rSecond = rSecond;
    }

    public static <E extends Event<?>> EventHandler<E> add(EventHandler<E> rFirst, EventHandler<E> rSecond) {
        if (rFirst == null) {
            return rSecond;
        }
        if (rSecond == null) {
            return rFirst;
        }
        return new EventMulticaster<E>(rFirst, rSecond);
    }

    public static <E extends Event<?>> EventHandler<E> remove(EventHandler<E> rListener, EventHandler<E> rToRemove) {
        if (rListener == rToRemove) {
            return null;
        }
        if (rListener instanceof EventMulticaster) {
            return ((EventMulticaster)rListener).remove(rToRemove);
        }
        return rListener;
    }

    @Override
    public void handleEvent(E rEvent) {
        this.rFirst.handleEvent(rEvent);
        this.rSecond.handleEvent(rEvent);
    }

    protected EventHandler<E> remove(EventHandler<E> rToRemove) {
        if (this.rFirst == rToRemove) {
            return this.rSecond;
        }
        if (this.rSecond == rToRemove) {
            return this.rFirst;
        }
        EventHandler<E> rRemoveFirst = EventMulticaster.remove(this.rFirst, rToRemove);
        EventHandler<E> rRemoveSecond = EventMulticaster.remove(this.rSecond, rToRemove);
        if (rRemoveFirst != this.rFirst || rRemoveSecond != this.rSecond) {
            return EventMulticaster.add(rRemoveFirst, rRemoveSecond);
        }
        return this;
    }
}

