/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression;

import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Functions;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.expression.function.AbstractFunction;
import de.esoco.lib.expression.function.AbstractInvertibleFunction;
import de.esoco.lib.expression.function.GetElement;
import de.esoco.lib.reflect.ReflectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CollectionFunctions {
    private static final Function<?, ?> AS_LIST = new AbstractInvertibleFunction<Object[], List<Object>>("AsList"){

        @Override
        public List<Object> evaluate(Object[] rArray) {
            return Arrays.asList(rArray);
        }

        @Override
        public Object[] invert(List<Object> rList) {
            return rList.toArray();
        }
    };
    private static final Function<?, ?> NEW_LIST = new AbstractFunction<List<Object>, List<Object>>("NewList"){

        @Override
        public List<Object> evaluate(List<Object> rList) {
            return new ArrayList<Object>(rList);
        }
    };
    private static final Function<?, ?> COPY_OF_COLLECTION = new AbstractFunction<Collection<Object>, Collection<Object>>("CopyOfCollection"){

        @Override
        public Collection<Object> evaluate(Collection<Object> rInput) {
            Collection aOutput = (Collection)ReflectUtil.newInstance(rInput.getClass());
            aOutput.addAll(rInput);
            return aOutput;
        }
    };
    private static final Function<Collection<?>, Integer> COLLECTION_SIZE = new AbstractFunction<Collection<?>, Integer>("CollectionSize"){

        @Override
        public Integer evaluate(Collection<?> rCollection) {
            return rCollection.size();
        }
    };
    private static final Function<Collection<?>, Object> CLEAR_COLLECTION = new AbstractFunction<Collection<?>, Object>("ClearCollection"){

        @Override
        public Object evaluate(Collection<?> rCollection) {
            rCollection.clear();
            return null;
        }
    };

    private CollectionFunctions() {
    }

    public static <T, C extends Collection<? super T>> BinaryFunction<C, T, Boolean> add(T rValue) {
        return new AbstractBinaryFunction<C, T, Boolean>(rValue, "AddToCollection"){

            @Override
            public Boolean evaluate(C rCollection, T rValue) {
                return rCollection.add(rValue);
            }
        };
    }

    public static <T> InvertibleFunction<T[], List<T>> asList() {
        return (InvertibleFunction)AS_LIST;
    }

    public static <C extends Collection<?>> Function<C, Object> clearCollection() {
        return CLEAR_COLLECTION;
    }

    public static <T, C extends Collection<T>> BinaryFunction<C, Predicate<? super T>, C> collect(Predicate<? super T> pCollect) {
        return new AbstractBinaryFunction<C, Predicate<? super T>, C>(pCollect, "Collect"){

            @Override
            public C evaluate(C rCollection, Predicate<? super T> rPredicate) {
                Object aResult = CollectionUtil.newCollectionLike(rCollection);
                for (Object rValue : rCollection) {
                    if (!((Boolean)rPredicate.evaluate(rValue)).booleanValue()) continue;
                    aResult.add(rValue);
                }
                return aResult;
            }
        };
    }

    public static <E, T extends Collection<E>, C extends Collection<E>> Function<C, T> collectAllInto(final T rTargetCollection) {
        return new AbstractFunction<C, T>("CollectAllInto"){

            @Override
            public T evaluate(C rCollection) {
                rTargetCollection.addAll(rCollection);
                return rTargetCollection;
            }
        };
    }

    public static <T, C extends Collection<T>> Function<T, C> collectInto(final C rCollection) {
        return new AbstractFunction<T, C>("CollectInto"){

            @Override
            public C evaluate(T rValue) {
                rCollection.add(rValue);
                return rCollection;
            }
        };
    }

    public static <C extends Collection<?>> Function<C, Integer> collectionSize() {
        return COLLECTION_SIZE;
    }

    public static <T, C extends Collection<T>> Function<C, C> copyOfCollection() {
        return COPY_OF_COLLECTION;
    }

    @SafeVarargs
    public static <I, O> Function<I, List<O>> createList(Function<? super I, O> ... rFunctions) {
        return CollectionFunctions.createList(Arrays.asList(rFunctions));
    }

    public static <I, O> Function<I, List<O>> createList(final Collection<Function<? super I, O>> rFunctions) {
        return new AbstractFunction<I, List<O>>("CreateList"){

            @Override
            public List<O> evaluate(I rInput) {
                ArrayList aResult = new ArrayList(rFunctions.size());
                for (Function rFunction : rFunctions) {
                    aResult.add(rFunction.evaluate(rInput));
                }
                return aResult;
            }
        };
    }

    public static <K, V> BinaryFunction<Collection<V>, Function<? super V, K>, Map<K, V>> createMap(Function<? super V, K> fKey) {
        return new AbstractBinaryFunction<Collection<V>, Function<? super V, K>, Map<K, V>>(fKey, "CreateMap"){

            @Override
            public Map<K, V> evaluate(Collection<V> rInputCollection, Function<? super V, K> rFunction) {
                LinkedHashMap aResult = new LinkedHashMap(rInputCollection.size());
                for (Object rValue : rInputCollection) {
                    aResult.put(rFunction.evaluate(rValue), rValue);
                }
                return aResult;
            }
        };
    }

    @SafeVarargs
    public static <I> Function<I, List<String>> createStringList(boolean bMapNull, Function<? super I, ?> ... rFunctions) {
        return CollectionFunctions.createStringList(bMapNull, Arrays.asList(rFunctions));
    }

    public static <I> Function<I, List<String>> createStringList(final boolean bMapNull, final Collection<Function<? super I, ?>> rFunctions) {
        return new AbstractFunction<I, List<String>>("CreateStringList"){

            @Override
            public List<String> evaluate(I rInput) {
                ArrayList<String> aResult = new ArrayList<String>(rFunctions.size());
                String sNullValue = bMapNull ? "" : null;
                for (Function rFunction : rFunctions) {
                    Object rValue = rFunction.evaluate(rInput);
                    aResult.add(rValue != null ? rValue.toString() : sNullValue);
                }
                return aResult;
            }
        };
    }

    public static <T> BinaryFunction<List<T>, Integer, T> extractListElement(int nIndex) {
        return new AbstractBinaryFunction<List<T>, Integer, T>(nIndex, "ExtractListElement"){

            @Override
            public T evaluate(List<T> rList, Integer rIndex) {
                int nIndex = rIndex;
                return rList.remove(nIndex == -1 ? rList.size() - 1 : nIndex);
            }
        };
    }

    public static <K, V> BinaryFunction<Map<K, V>, K, V> extractMapValue(K rKey) {
        return new AbstractBinaryFunction<Map<K, V>, K, V>(rKey, "ExtractMapValue"){

            @Override
            public V evaluate(Map<K, V> rMap, K rKey) {
                return rMap.remove(rKey);
            }
        };
    }

    public static <T, C extends Collection<T>> BinaryFunction<C, Predicate<? super T>, T> find(Predicate<? super T> rPredicate) {
        return new AbstractBinaryFunction<C, Predicate<? super T>, T>(rPredicate, "Find"){

            @Override
            public T evaluate(C rCollection, Predicate<? super T> rPredicate) {
                for (Object rValue : rCollection) {
                    if (!((Boolean)rPredicate.evaluate(rValue)).booleanValue()) continue;
                    return rValue;
                }
                return null;
            }
        };
    }

    public static <T, C extends Collection<T>> BinaryFunction<C, Function<? super T, ?>, C> forEach(Function<T, ?> rFunction) {
        return new AbstractBinaryFunction<C, Function<? super T, ?>, C>(rFunction, "ForEach"){

            @Override
            public C evaluate(C rCollection, Function<? super T, ?> rFunction) {
                for (Object rValue : rCollection) {
                    rFunction.evaluate(rValue);
                }
                return rCollection;
            }
        };
    }

    public static <T> BinaryFunction<List<T>, Integer, T> getListElement(int nIndex) {
        return new GetElement.GetListElement(nIndex);
    }

    public static <T> BinaryFunction<Integer, List<T>, T> getListElementAt(List<T> rList) {
        BinaryFunction<List<T>, Integer, T> rListElement = CollectionFunctions.getListElement(0);
        return Functions.swapParams(rListElement, rList);
    }

    public static <K, V> BinaryFunction<Map<K, V>, K, V> getMapValue(K rKey) {
        return new GetElement.GetMapValue(rKey);
    }

    public static <K, V> BinaryFunction<K, Map<K, V>, V> getMapValueFrom(Map<K, V> rMap) {
        return Functions.swapParams(new GetElement.GetMapValue(null), rMap);
    }

    public static <T> BinaryFunction<T, List<? super T>, Integer> indexIn(List<? super T> rList) {
        BinaryFunction<List<Object>, Object, Integer> rIndexOf = CollectionFunctions.indexOf(null);
        return Functions.swapParams(rIndexOf, rList);
    }

    public static <T> BinaryFunction<List<? super T>, T, Integer> indexOf(T rElement) {
        return new AbstractBinaryFunction<List<? super T>, T, Integer>(rElement, "IndexOf"){

            @Override
            public Integer evaluate(List<? super T> rList, T rElement) {
                return rList.indexOf(rElement);
            }
        };
    }

    public static <I, O, C extends Collection<I>> BinaryFunction<C, Function<? super I, O>, Collection<O>> map(Function<? super I, O> fMap) {
        return new AbstractBinaryFunction<C, Function<? super I, O>, Collection<O>>(fMap, "MapCollection"){

            @Override
            public Collection<O> evaluate(C rInputCollection, Function<? super I, O> rFunction) {
                Object aResult = CollectionUtil.newCollectionLike(rInputCollection);
                for (Object rValue : rInputCollection) {
                    aResult.add(rFunction.evaluate(rValue));
                }
                return aResult;
            }
        };
    }

    public static <T> Function<List<T>, List<T>> newList() {
        return NEW_LIST;
    }

    public static <T, C extends Collection<T>> BinaryFunction<C, BinaryFunction<T, T, T>, T> reduce(BinaryFunction<T, T, T> fReduce) {
        return new AbstractBinaryFunction<C, BinaryFunction<T, T, T>, T>(fReduce, "Reduce"){

            @Override
            public T evaluate(C rCollection, BinaryFunction<T, T, T> rFunction) {
                Object aResult = null;
                for (Object rValue : rCollection) {
                    aResult = aResult != null ? rFunction.evaluate(aResult, rValue) : rValue;
                }
                return aResult;
            }
        };
    }
}

