/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression;

import de.esoco.lib.expression.BinaryPredicate;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.predicate.AbstractBinaryPredicate;
import de.esoco.lib.expression.predicate.AbstractPredicate;
import de.esoco.lib.expression.predicate.Comparison;
import java.util.Arrays;
import java.util.Collection;

public class CollectionPredicates {
    private static final Predicate<Collection<?>> IS_EMPTY = new AbstractPredicate<Collection<?>>("IsEmpty"){

        @Override
        public final Boolean evaluate(Collection<?> rCollection) {
            return rCollection.isEmpty();
        }
    };

    private CollectionPredicates() {
    }

    public static <T, C extends Collection<T>> BinaryPredicate<C, T> contains(T rElement) {
        return new AbstractBinaryPredicate<C, T>(rElement, "Contains"){

            @Override
            public Boolean evaluate(C rCollection, T rElement) {
                return rCollection.contains(rElement);
            }
        };
    }

    public static <T> Predicate<T> elementOf(Collection<?> rCollection) {
        return new Comparison.ElementOf(rCollection, true);
    }

    public static <T> Predicate<T> elementOf(Object ... rValues) {
        return new Comparison.ElementOf(Arrays.asList(rValues), true);
    }

    public static Predicate<Collection<?>> isEmpty() {
        return IS_EMPTY;
    }
}

