/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression;

import de.esoco.lib.expression.Functions;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.expression.function.AbstractInvertibleFunction;
import de.esoco.lib.property.HasOrder;
import de.esoco.lib.reflect.ReflectUtil;
import de.esoco.lib.text.TextConvert;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.obrel.core.RelationType;
import org.obrel.type.MetaTypes;

public class Conversions {
    private static Map<Class<?>, InvertibleFunction<?, String>> aStringConversions;

    private Conversions() {
    }

    public static String asString(Object rValue) {
        String sValue;
        if (rValue == null) {
            sValue = "null";
        } else if (rValue instanceof Collection) {
            sValue = Conversions.asString((Collection)rValue, ",");
        } else if (rValue instanceof Map) {
            sValue = Conversions.asString((Map)rValue, ",", "=");
        } else {
            InvertibleFunction<?, String> rConversion = Conversions.getStringConversion(rValue.getClass());
            if (rConversion == null) {
                throw new IllegalArgumentException("No string conversion registered for " + rValue.getClass());
            }
            sValue = (String)rConversion.evaluate(rValue);
        }
        return sValue;
    }

    public static String asString(Collection<?> rCollection, String sSeparator) {
        StringBuilder aResult = new StringBuilder();
        if (rCollection.size() > 0) {
            for (Object rElement : rCollection) {
                String sElement = Conversions.asString(rElement);
                aResult.append(TextConvert.unicodeEncode((String)sElement, (String)sSeparator));
                aResult.append(sSeparator);
            }
            aResult.setLength(aResult.length() - sSeparator.length());
        }
        return aResult.toString();
    }

    public static String asString(Map<?, ?> rMap, String sEntrySeparator, String sKeyValueSeparator) {
        StringBuilder aResult = new StringBuilder();
        if (rMap.size() > 0) {
            for (Map.Entry<?, ?> rEntry : rMap.entrySet()) {
                String sKey = Conversions.asString(rEntry.getKey());
                String sValue = Conversions.asString(rEntry.getValue());
                assert (sKey.indexOf(sEntrySeparator) < 0 && sKey.indexOf(sKeyValueSeparator) < 0);
                aResult.append(sKey);
                aResult.append(sKeyValueSeparator);
                aResult.append(TextConvert.unicodeEncode((String)sValue, (String)sEntrySeparator));
                aResult.append(sEntrySeparator);
            }
            aResult.setLength(aResult.length() - sEntrySeparator.length());
        }
        return aResult.toString();
    }

    public static <E extends Enum<E>> InvertibleFunction<E, String> enumToString(final Class<E> rEnumClass) {
        return new StringConversion<E>(rEnumClass){

            @Override
            public E invert(String sEnumName) {
                return Enum.valueOf(rEnumClass, sEnumName);
            }
        };
    }

    public static <T, E extends Enum<E>> InvertibleFunction<T, String> getStringConversion(Class<T> rDatatype) {
        Map<Class<?>, InvertibleFunction<?, String>> rConversions = Conversions.getStringConversionMap();
        InvertibleFunction<Object, String> rConversion = rConversions.get(rDatatype);
        if (rConversion == null) {
            if (rDatatype.isEnum()) {
                rConversion = Conversions.enumToString(rDatatype);
                rConversions.put(rDatatype, rConversion);
            } else {
                Class<T> rSuperclass = rDatatype;
                do {
                    if ((rSuperclass = rSuperclass.getSuperclass()) != Object.class) {
                        rConversion = rConversions.get(rSuperclass);
                        continue;
                    }
                    rConversion = new StringConversion(rDatatype);
                    rConversions.put(rDatatype, rConversion);
                } while (rConversion == null);
            }
        }
        return rConversion;
    }

    public static <E, C extends Collection<E>> C parseCollection(String sElements, Class<C> rCollectionType, Class<E> rElementType, boolean bOrdered) {
        return Conversions.parseCollection(sElements, rCollectionType, rElementType, ",", bOrdered);
    }

    public static <E, C extends Collection<E>> C parseCollection(String sElements, Class<C> rCollectionType, Class<E> rElementType, String sSeparator, boolean bOrdered) {
        Class<Object> rCollectionClass = null;
        if (bOrdered) {
            Class<LinkedHashSet> rSetClass = LinkedHashSet.class;
            rCollectionClass = rSetClass;
        } else {
            rCollectionClass = ReflectUtil.getImplementationClass(rCollectionType);
        }
        Collection aCollection = (Collection)ReflectUtil.newInstance(rCollectionClass);
        if (sElements != null) {
            StringTokenizer aElements = new StringTokenizer(sElements, sSeparator);
            while (aElements.hasMoreElements()) {
                String sElement = TextConvert.unicodeDecode((String)aElements.nextToken(), (String)sSeparator);
                aCollection.add(Conversions.parseValue(sElement, rElementType));
            }
        }
        return (C)aCollection;
    }

    public static <K, V, M extends Map<K, V>> Map<K, V> parseMap(String sMapEntries, Class<M> rMapType, Class<K> rKeyType, Class<V> rValueType, boolean bOrdered) {
        return Conversions.parseMap(sMapEntries, rMapType, rKeyType, rValueType, ",", "=", bOrdered);
    }

    public static <K, V, M extends Map<K, V>> Map<K, V> parseMap(String sMapEntries, Class<M> rMapType, Class<K> rKeyType, Class<V> rValueType, String sEntrySeparator, String sKeyValueSeparator, boolean bOrdered) {
        Class rMapClass = bOrdered ? LinkedHashMap.class : ReflectUtil.getImplementationClass(rMapType);
        Map aMap = ReflectUtil.newInstance(rMapClass);
        if (sMapEntries != null) {
            StringTokenizer aElements = new StringTokenizer(sMapEntries, sEntrySeparator);
            while (aElements.hasMoreElements()) {
                String sEntry = aElements.nextToken();
                int nKeyEnd = sEntry.indexOf(sKeyValueSeparator);
                String sKey = sEntry.substring(0, nKeyEnd);
                String sValue = sEntry.substring(nKeyEnd + sKeyValueSeparator.length());
                sValue = TextConvert.unicodeDecode((String)sValue, (String)sEntrySeparator);
                aMap.put(Conversions.parseValue(sKey, rKeyType), Conversions.parseValue(sValue, rValueType));
            }
        }
        return aMap;
    }

    public static <T> T parseValue(String sValue, Class<T> rDatatype) {
        if (rDatatype == null) {
            throw new NullPointerException("Datatype must not be NULL");
        }
        if (sValue == null || sValue.equals("null")) {
            return null;
        }
        InvertibleFunction<T, String> rConversion = Conversions.getStringConversion(rDatatype);
        if (rConversion == null) {
            throw new IllegalArgumentException("No string conversion registered for " + rDatatype);
        }
        return rConversion.invert(sValue);
    }

    public static <T> T parseValue(String sValue, RelationType<T> rTargetType) {
        Object aResult;
        Class<T> rDatatype = rTargetType.getTargetType();
        boolean bOrdered = rTargetType.hasFlag(MetaTypes.ORDERED);
        if (Collection.class.isAssignableFrom(rDatatype)) {
            aResult = Conversions.parseCollection(sValue, rDatatype, rTargetType.get(MetaTypes.ELEMENT_DATATYPE), bOrdered);
        } else if (Map.class.isAssignableFrom(rDatatype)) {
            aResult = Conversions.parseMap(sValue, rDatatype, rTargetType.get(MetaTypes.KEY_DATATYPE), rTargetType.get(MetaTypes.VALUE_DATATYPE), bOrdered);
        } else {
            if (rDatatype.isEnum() && HasOrder.class.isAssignableFrom(rDatatype)) {
                sValue = sValue.substring(sValue.indexOf(45) + 1);
            }
            aResult = Conversions.parseValue(sValue, rDatatype);
        }
        return aResult;
    }

    public static <T> void registerStringConversion(Class<T> rDatatype, InvertibleFunction<? super T, String> rConversion) {
        Conversions.getStringConversionMap().put(rDatatype, rConversion);
    }

    private static Map<Class<?>, InvertibleFunction<?, String>> getStringConversionMap() {
        if (aStringConversions == null) {
            aStringConversions = new HashMap();
            aStringConversions.put(String.class, Functions.identity());
            aStringConversions.put(Boolean.class, new StringConversion<Boolean>(Boolean.class){

                @Override
                public Boolean invert(String sValue) {
                    return Boolean.valueOf(sValue);
                }
            });
            aStringConversions.put(Integer.class, new StringConversion<Integer>(Integer.class){

                @Override
                public Integer invert(String sValue) {
                    return Integer.valueOf(sValue);
                }
            });
            aStringConversions.put(Long.class, new StringConversion<Long>(Long.class){

                @Override
                public Long invert(String sValue) {
                    return Long.valueOf(sValue);
                }
            });
            aStringConversions.put(Short.class, new StringConversion<Short>(Short.class){

                @Override
                public Short invert(String sValue) {
                    return Short.valueOf(sValue);
                }
            });
            aStringConversions.put(Float.class, new StringConversion<Float>(Float.class){

                @Override
                public Float invert(String sValue) {
                    return Float.valueOf(sValue);
                }
            });
            aStringConversions.put(Double.class, new StringConversion<Double>(Double.class){

                @Override
                public Double invert(String sValue) {
                    return Double.valueOf(sValue);
                }
            });
            aStringConversions.put(BigDecimal.class, new StringConversion<BigDecimal>(BigDecimal.class));
            aStringConversions.put(BigInteger.class, new StringConversion<BigInteger>(BigInteger.class));
            aStringConversions.put(Date.class, new DateToStringConversion());
            aStringConversions.put(Class.class, new ClassToStringConversion());
        }
        return aStringConversions;
    }

    private static class ClassToStringConversion
    extends StringConversion<Class> {
        ClassToStringConversion() {
            super(Class.class);
        }

        @Override
        public String evaluate(Class rClass) {
            return rClass.getName();
        }

        @Override
        public Class<?> invert(String sValue) {
            try {
                return Class.forName(sValue);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static class StringConversion<T>
    extends AbstractInvertibleFunction<T, String> {
        private static final Class<?>[] STRING_ARG = new Class[]{String.class};
        private final Class<T> rDatatype;

        public StringConversion(Class<T> rDatatype) {
            super(rDatatype.getSimpleName() + "ToString");
            this.rDatatype = rDatatype;
        }

        @Override
        public String evaluate(T rValue) {
            return rValue.toString();
        }

        @Override
        public T invert(String sValue) {
            return ReflectUtil.newInstance(this.rDatatype, new Object[]{sValue}, STRING_ARG);
        }
    }

    public static class DateToStringConversion
    extends AbstractInvertibleFunction<Date, String> {
        public DateToStringConversion() {
            super("DateToString");
        }

        @Override
        public String evaluate(Date rDate) {
            return Long.toString(rDate.getTime());
        }

        @Override
        public Date invert(String sValue) {
            return new Date(Long.parseLong(sValue));
        }
    }
}

