/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression;

import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.expression.function.AbstractFunction;

public class MathFunctions {
    private static final Function<String, Integer> PARSE_INTEGER = new AbstractFunction<String, Integer>("ParseInteger"){

        @Override
        public Integer evaluate(String sValue) {
            return Integer.valueOf(sValue);
        }
    };

    private MathFunctions() {
    }

    public static BinaryFunction<Integer, Integer, Integer> add(int nRightValue) {
        return new AbstractBinaryFunction<Integer, Integer, Integer>(Integer.valueOf(nRightValue), "Add", false){

            @Override
            public Integer evaluate(Integer rLeftValue, Integer rRightValue) {
                return rLeftValue + rRightValue;
            }
        };
    }

    public static BinaryFunction<Integer, Integer, Integer> divide(int nRightValue) {
        return new AbstractBinaryFunction<Integer, Integer, Integer>(Integer.valueOf(nRightValue), "Divide", false){

            @Override
            public Integer evaluate(Integer rLeftValue, Integer rRightValue) {
                return rLeftValue / rRightValue;
            }
        };
    }

    public static BinaryFunction<Integer, Integer, Integer> modulo(int nRightValue) {
        return new AbstractBinaryFunction<Integer, Integer, Integer>(Integer.valueOf(nRightValue), "Modulo", false){

            @Override
            public Integer evaluate(Integer rLeftValue, Integer rRightValue) {
                return rLeftValue % rRightValue;
            }
        };
    }

    public static BinaryFunction<Integer, Integer, Integer> multiply(int nRightValue) {
        return new AbstractBinaryFunction<Integer, Integer, Integer>(Integer.valueOf(nRightValue), "Multiply", false){

            @Override
            public Integer evaluate(Integer rLeftValue, Integer rRightValue) {
                return rLeftValue * rRightValue;
            }
        };
    }

    public static Function<String, Integer> parseInteger() {
        return PARSE_INTEGER;
    }

    public static BinaryFunction<Integer, Integer, Integer> subtract(int nRightValue) {
        return new AbstractBinaryFunction<Integer, Integer, Integer>(Integer.valueOf(nRightValue), "Subtract", false){

            @Override
            public Integer evaluate(Integer rLeftValue, Integer rRightValue) {
                return rLeftValue - rRightValue;
            }
        };
    }
}

