/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression;

import de.esoco.lib.expression.BinaryPredicate;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.function.GetElement;
import de.esoco.lib.expression.predicate.AbstractBinaryPredicate;
import de.esoco.lib.expression.predicate.AbstractPredicate;
import de.esoco.lib.expression.predicate.BinaryPredicateChain;
import de.esoco.lib.expression.predicate.ClassPredicate;
import de.esoco.lib.expression.predicate.Comparison;
import de.esoco.lib.expression.predicate.ElementPredicate;
import de.esoco.lib.expression.predicate.FunctionPredicate;
import de.esoco.lib.expression.predicate.PredicateChain;
import de.esoco.lib.expression.predicate.PredicateJoin;
import java.util.regex.Pattern;
import org.obrel.core.Relatable;
import org.obrel.core.RelationType;
import org.obrel.type.MetaTypes;

public class Predicates {
    private static final Predicate<?> TRUE = new AbstractPredicate<Object>("TRUE"){

        @Override
        public final Boolean evaluate(Object rValue) {
            return true;
        }
    };
    private static final Predicate<?> FALSE = new AbstractPredicate<Object>("FALSE"){

        @Override
        public final Boolean evaluate(Object rValue) {
            return false;
        }
    };
    private static final Predicate<?> IS_NULL = new Comparison.EqualTo<Object>(null){

        @Override
        public final Boolean evaluate(Object rValue, Object rNull) {
            return rValue == null;
        }
    };
    private static final Predicate<?> NOT_NULL = Predicates.not(IS_NULL);
    private static final Predicate<Relatable> IS_MODIFIED = Predicates.hasFlag(MetaTypes.MODIFIED);
    private static final Predicate<Relatable> IS_NOT_MODIFIED = Predicates.not(IS_MODIFIED);

    private Predicates() {
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Predicate<T> and(Predicate<? super T> rFirst, Predicate<? super T> rSecond) {
        if (rSecond == null) {
            return rFirst;
        }
        if (rFirst == null) {
            return rSecond;
        }
        return new And<T>(rFirst, rSecond);
    }

    public static <T, I> Predicate<T> chain(Predicate<I> rOuter, Function<T, ? extends I> rInner) {
        return new PredicateChain<T, I>(rOuter, rInner);
    }

    public static <L, R, V, W> BinaryPredicate<L, R> chain(BinaryPredicate<V, W> rOuter, Function<L, ? extends V> rLeft, Function<R, ? extends W> rRight) {
        return new BinaryPredicateChain<L, R, V, W>(rOuter, rLeft, rRight);
    }

    public static <T> Predicate<T> countDown(final int nValue) {
        return new AbstractPredicate<T>("countDown"){
            int nCountValue;
            {
                super(sToken);
                this.nCountValue = nValue;
            }

            @Override
            public Boolean evaluate(T rValue) {
                return this.nCountValue-- > 0;
            }
        };
    }

    public static <T> Comparison<T, Object> equalTo(Object rValue) {
        return new Comparison.EqualTo(rValue);
    }

    public static Predicate<?> firstInChain(Predicate<?> rPredicate) {
        if (rPredicate instanceof PredicateJoin) {
            rPredicate = Predicates.firstInChain(((PredicateJoin)rPredicate).getLeft());
        }
        return rPredicate;
    }

    public static <T extends Comparable<T>> Comparison<T, T> greaterOrEqual(T rValue) {
        return new Comparison.GreaterOrEqual<T>(rValue);
    }

    public static <T extends Comparable<T>> Comparison<T, T> greaterThan(T rValue) {
        return new Comparison.GreaterThan<T>(rValue);
    }

    public static <T> ClassPredicate<T> hasBaseClass(Class<?> rClass) {
        return new ClassPredicate.HasBaseClass(rClass);
    }

    public static <T> ClassPredicate<T> hasClass(Class<?> rClass) {
        return new ClassPredicate.HasClass(rClass);
    }

    public static <R extends Relatable> Predicate<R> hasFlag(RelationType<Boolean> rType) {
        return new AbstractBinaryPredicate<R, RelationType<Boolean>>(rType, "hasRelation", true){

            @Override
            public Boolean evaluate(R rRelatable, RelationType<Boolean> rFlagType) {
                return rRelatable.hasFlag(rFlagType);
            }
        };
    }

    public static <R extends Relatable> Predicate<R> hasRelation(RelationType<?> rType) {
        return new AbstractBinaryPredicate<R, RelationType<?>>(rType, "hasRelation", true){

            @Override
            public Boolean evaluate(R rRelatable, RelationType<?> rType) {
                return rRelatable.hasRelation(rType);
            }
        };
    }

    public static <T, V> ElementPredicate<T, V> ifField(String sField, Predicate<V> rPredicate) {
        return new ElementPredicate(new GetElement.ReadField(sField), rPredicate);
    }

    public static <T, V> ElementPredicate<T, V> ifProperty(String sProperty, Predicate<V> rPredicate) {
        return new ElementPredicate(new GetElement.GetField(sProperty), rPredicate);
    }

    public static <T extends Relatable, V> Predicate<T> ifProperty(RelationType<V> rType, Predicate<? super V> rPredicate) {
        return Predicates.ifRelation(rType, rPredicate);
    }

    public static <T extends Relatable, V> Predicate<T> ifRelation(RelationType<V> rType, Predicate<? super V> rPredicate) {
        return new ElementPredicate(rType, rPredicate);
    }

    public static <T> Predicate<T> isFirstCall() {
        return new AbstractPredicate<T>("isFirstCall"){
            boolean bIsFirst = true;

            @Override
            public Boolean evaluate(T rIgnored) {
                boolean bResult = this.bIsFirst;
                this.bIsFirst = false;
                return bResult;
            }
        };
    }

    public static <T> Predicate<T> isNull() {
        return IS_NULL;
    }

    public static <T extends Comparable<T>> Comparison<T, T> lessOrEqual(T rValue) {
        return new Comparison.LessOrEqual<T>(rValue);
    }

    public static <T extends Comparable<T>> Comparison<T, T> lessThan(T rValue) {
        return new Comparison.LessThan<T>(rValue);
    }

    public static <T> Predicate<T> matching(String sRegularExpression) {
        return new Comparison.Matching(sRegularExpression);
    }

    public static <T> Predicate<T> matching(Pattern rPattern) {
        return new Comparison.Matching(rPattern);
    }

    public static <R extends Relatable> Predicate<R> modified() {
        return IS_MODIFIED;
    }

    public static <T> Predicate<T> not(Predicate<T> rPredicate) {
        return new Not<T>(rPredicate);
    }

    public static <R extends Relatable> Predicate<R> notModified() {
        return IS_NOT_MODIFIED;
    }

    public static <T> Predicate<T> notNull() {
        return NOT_NULL;
    }

    public static <T> Predicate<T> or(Predicate<? super T> rFirst, Predicate<? super T> rSecond) {
        if (rSecond == null) {
            return rFirst;
        }
        if (rFirst == null) {
            return rSecond;
        }
        return new Or<T>(rFirst, rSecond);
    }

    public static <T> Comparison<T, Object> sameAs(Object rValue) {
        return new Comparison.SameAs(rValue);
    }

    public static <T, V> Predicate<T> when(Function<T, V> rFunction, Predicate<? super V> rPredicate) {
        return new FunctionPredicate<T, V>(rFunction, rPredicate);
    }

    public static class Or<T>
    extends PredicateJoin<T> {
        Or(Predicate<? super T> rLeft, Predicate<? super T> rRight) {
            super(rLeft, rRight, "||");
        }

        @Override
        protected Boolean evaluate(Predicate<? super T> rLeft, Predicate<? super T> rRight, T rValue) {
            return (Boolean)rLeft.evaluate(rValue) != false || (Boolean)rRight.evaluate(rValue) != false;
        }
    }

    public static class Not<T>
    extends AbstractPredicate<T> {
        private final Predicate<T> rPredicate;

        public Not(Predicate<T> rPredicate) {
            super("NOT");
            this.rPredicate = rPredicate;
        }

        @Override
        public Boolean evaluate(T rTarget) {
            return (Boolean)this.rPredicate.evaluate(rTarget) == false;
        }

        public final Predicate<T> getPredicate() {
            return this.rPredicate;
        }

        @Override
        public String toString() {
            return this.getToken() + " " + this.rPredicate;
        }
    }

    public static class And<T>
    extends PredicateJoin<T> {
        And(Predicate<? super T> rLeft, Predicate<? super T> rRight) {
            super(rLeft, rRight, "&&");
        }

        @Override
        protected Boolean evaluate(Predicate<? super T> rLeft, Predicate<? super T> rRight, T rValue) {
            return (Boolean)rLeft.evaluate(rValue) != false && (Boolean)rRight.evaluate(rValue) != false;
        }
    }
}

