/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression;

import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.expression.function.AbstractFunction;
import de.esoco.lib.expression.function.AbstractInvertibleFunction;
import de.esoco.lib.expression.function.ExceptionMappingBinaryFunction;
import de.esoco.lib.expression.function.GetSubstring;
import de.esoco.lib.expression.predicate.AbstractPredicate;
import de.esoco.lib.reflect.ReflectUtil;
import de.esoco.lib.text.TextConvert;
import de.esoco.lib.text.TextUtil;
import java.net.IDN;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringFunctions {
    private static final Function<CharSequence, Integer> STRING_LENGTH = new AbstractFunction<CharSequence, Integer>("StringLength"){

        @Override
        public Integer evaluate(CharSequence sValue) {
            return sValue.length();
        }
    };
    private static final Function<String, String> TRIM = new AbstractFunction<String, String>("Trim"){

        @Override
        public String evaluate(String sValue) {
            return sValue.trim();
        }
    };
    private static final Function<String, String> TO_LOWER_CASE = new AbstractFunction<String, String>("ToLowerCase"){

        @Override
        public String evaluate(String sValue) {
            return sValue.toLowerCase();
        }
    };
    private static final Function<String, String> TO_UPPER_CASE = new AbstractFunction<String, String>("ToUpperCase"){

        @Override
        public String evaluate(String sValue) {
            return sValue.toUpperCase();
        }
    };
    private static final InvertibleFunction<String, byte[]> TO_BYTE_ARRAY = new AbstractInvertibleFunction<String, byte[]>("ToByteArray"){

        @Override
        public byte[] evaluate(String sValue) {
            return sValue != null ? sValue.getBytes() : null;
        }

        @Override
        public String invert(byte[] rValue) {
            return rValue != null ? new String(rValue) : null;
        }
    };
    private static final Function<String, String> CAPITALIZED_IDENTIFIER = new AbstractFunction<String, String>("CapitalizedIdentifier"){

        @Override
        public String evaluate(String sValue) {
            return TextUtil.capitalizedIdentifier((String)sValue);
        }
    };
    private static final Function<String, String> UPPERCASE_IDENTIFIER = new AbstractFunction<String, String>("UppercaseIdentifier"){

        @Override
        public String evaluate(String sValue) {
            return TextUtil.uppercaseIdentifier((String)sValue);
        }
    };
    private static final Predicate<CharSequence> IS_EMPTY = new AbstractPredicate<CharSequence>("StringIsEmpty"){

        @Override
        public Boolean evaluate(CharSequence rValue) {
            return rValue == null || rValue.length() == 0;
        }
    };
    private static final Predicate<CharSequence> IS_NOT_EMPTY = new AbstractPredicate<CharSequence>("StringIsNotEmpty"){

        @Override
        public Boolean evaluate(CharSequence rValue) {
            return rValue != null && rValue.length() > 0;
        }
    };
    private static final Predicate<String> IS_VALID_IDN_UNICODE = new AbstractPredicate<String>("IsValidIdnUnicode"){

        @Override
        public Boolean evaluate(String sIDN) {
            try {
                IDN.toASCII(sIDN);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    };
    private static final Function<String, String> IDN_UNICODE_TO_ASCII = new AbstractFunction<String, String>("IdnUnicodeToAscii"){

        @Override
        public String evaluate(String sValue) {
            return IDN.toASCII(sValue);
        }
    };
    private static final Function<String, String> IDN_ASCII_TO_UNICODE = new AbstractFunction<String, String>("IdnAsciiToUnicode"){

        @Override
        public String evaluate(String sValue) {
            return IDN.toUnicode(sValue);
        }
    };

    private StringFunctions() {
    }

    public static BinaryFunction<String, String, String> capitalize(String sSeparator) {
        return new AbstractBinaryFunction<String, String, String>(sSeparator, "Capitalize"){

            @Override
            public String evaluate(String sText, String sSeparator) {
                return TextConvert.capitalize((String)sText, (String)sSeparator);
            }
        };
    }

    public static Function<String, String> capitalizedIdentifier() {
        return CAPITALIZED_IDENTIFIER;
    }

    public static Predicate<String> contains(final String sString) {
        return new AbstractPredicate<String>("Contains"){

            @Override
            public Boolean evaluate(String sValue) {
                return sValue.contains(sString);
            }
        };
    }

    public static BinaryFunction<byte[], Charset, String> createString(Charset rCharset) {
        return new ExceptionMappingBinaryFunction<byte[], Charset, String>(rCharset, "createString"){

            @Override
            protected String evaluateWithException(byte[] rBytes, Charset rCharset) throws Exception {
                return new String(rBytes, rCharset);
            }
        };
    }

    public static BinaryFunction<String, String, String> find(String sRegex) {
        return new AbstractBinaryFunction<String, String, String>(sRegex, "Find"){

            @Override
            public String evaluate(String sInput, String sRegex) {
                Matcher aMatcher = Pattern.compile(sRegex).matcher(sInput);
                return aMatcher.find() ? aMatcher.group() : null;
            }
        };
    }

    public static <T> BinaryFunction<T, String, String> format(String sPattern) {
        return new AbstractBinaryFunction<T, String, String>(sPattern, "StringFormat"){

            @Override
            public String evaluate(T rValue, String sPattern) {
                return String.format(sPattern, rValue);
            }
        };
    }

    public static Function<String, String> idnAsciiToUnicode() {
        return IDN_ASCII_TO_UNICODE;
    }

    public static Function<String, String> idnUnicodeToAscii() {
        return IDN_UNICODE_TO_ASCII;
    }

    public static Predicate<CharSequence> isEmpty() {
        return IS_EMPTY;
    }

    public static Predicate<String> isValidIdnUnicode() {
        return IS_VALID_IDN_UNICODE;
    }

    public static Predicate<CharSequence> notEmpty() {
        return IS_NOT_EMPTY;
    }

    public static BinaryFunction<String, String, String[]> split(String sPattern) {
        return new AbstractBinaryFunction<String, String, String[]>(sPattern, "StringSplit"){

            @Override
            public String[] evaluate(String sValue, String sPattern) {
                return sValue.split(sPattern);
            }
        };
    }

    public static Function<CharSequence, Integer> stringLength() {
        return STRING_LENGTH;
    }

    public static GetSubstring substring(int nBeginIndex, int nEndIndex) {
        return new GetSubstring(nBeginIndex, nEndIndex);
    }

    public static InvertibleFunction<String, byte[]> toByteArray() {
        return TO_BYTE_ARRAY;
    }

    public static <C extends Collection<String>> BinaryFunction<String, String, C> toCollection(final Class<C> rCollectionClass, String sSplitPattern, final boolean bTrim) {
        return new AbstractBinaryFunction<String, String, C>(sSplitPattern, "StringSplit"){

            @Override
            public C evaluate(String sValue, String sPattern) {
                Collection aResult = (Collection)ReflectUtil.newInstance(rCollectionClass);
                if (sValue != null && sValue.length() > 0) {
                    String[] aSplit;
                    for (String sElement : aSplit = sValue.split(sPattern)) {
                        aResult.add(bTrim ? sElement.trim() : sElement);
                    }
                }
                return aResult;
            }
        };
    }

    public static <C extends Collection<String>> BinaryFunction<String, String, List<String>> toList(String sSplitPattern, boolean bTrim) {
        Class<ArrayList> rListClass = ArrayList.class;
        return StringFunctions.toCollection(rListClass, sSplitPattern, bTrim);
    }

    public static List<String> toList(String sInput, String sSplitPattern, boolean bTrim) {
        return (List)StringFunctions.toList(sSplitPattern, bTrim).evaluate(sInput);
    }

    public static Function<String, String> toLowerCase() {
        return TO_LOWER_CASE;
    }

    public static <C extends Collection<String>> BinaryFunction<String, String, Set<String>> toSet(String sSplitPattern, boolean bTrim, boolean bOrdered) {
        Class rSetClass = bOrdered ? LinkedHashSet.class : HashSet.class;
        return StringFunctions.toCollection(rSetClass, sSplitPattern, bTrim);
    }

    public static Set<String> toSet(String sInput, String sSplitPattern, boolean bTrim, boolean bOrdered) {
        return (Set)StringFunctions.toSet(sSplitPattern, bTrim, bOrdered).evaluate(sInput);
    }

    public static Function<String, String> toUpperCase() {
        return TO_UPPER_CASE;
    }

    public static Function<String, String> trim() {
        return TRIM;
    }

    public static Function<String, String> uppercaseIdentifier() {
        return UPPERCASE_IDENTIFIER;
    }
}

