/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Functions;
import de.esoco.lib.expression.function.AbstractFunction;

public abstract class AbstractBinaryFunction<L, R, O>
extends AbstractFunction<L, O>
implements BinaryFunction<L, R, O> {
    private R rRightValue;
    private final boolean bImmutable;

    public AbstractBinaryFunction(R rRightValue, String sToken) {
        this(rRightValue, sToken, true);
    }

    public AbstractBinaryFunction(R rRightValue, String sToken, boolean bImmutable) {
        super(sToken);
        this.rRightValue = rRightValue;
        this.bImmutable = bImmutable;
    }

    @Override
    public final O evaluate(L rLeftValue) {
        return this.evaluate(rLeftValue, this.rRightValue);
    }

    @Override
    public <A, B> BinaryFunction<A, B, O> from(Function<A, ? extends L> rLeft, Function<B, ? extends R> rRight) {
        return Functions.chain(this, rLeft, rRight);
    }

    @Override
    public final R getRightValue() {
        return this.rRightValue;
    }

    public final boolean isImmutable() {
        return this.bImmutable;
    }

    @Override
    public final void setRightValue(R rValue) {
        if (this.bImmutable) {
            throw new IllegalStateException("Binary function is immutable: " + this);
        }
        this.rRightValue = rValue;
    }

    public <T> BinaryFunction<L, R, T> thenLeft(BinaryFunction<? super O, R, T> rOther) {
        return Functions.chainLeft(rOther, this);
    }

    public <T> BinaryFunction<L, R, T> thenRight(BinaryFunction<L, ? super O, T> rOther) {
        return Functions.chainRight(rOther, this);
    }

    @Override
    public String toString() {
        return this.getToken() + "(" + "#" + ", " + this.rRightValue + ")";
    }

    @Override
    public <T> BinaryFunction<L, T, O> withRight(Function<T, ? extends R> fRight) {
        return this.from(Functions.identity(), fRight);
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        boolean bEqual;
        AbstractBinaryFunction rOtherFunction = (AbstractBinaryFunction)rOther;
        boolean bl = bEqual = this.bImmutable == rOtherFunction.bImmutable;
        if (bEqual) {
            bEqual = this.rRightValue != null ? this.rRightValue.equals(rOtherFunction.rRightValue) : rOtherFunction.rRightValue == null;
        }
        return bEqual;
    }

    @Override
    protected int paramsHashCode() {
        return (this.rRightValue != null ? this.rRightValue.hashCode() : 0) + (this.bImmutable ? 1 : 0);
    }
}

