/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.function.AbstractFunction;

public class ConditionalFunction<I, O>
extends AbstractFunction<I, O> {
    private final Predicate<? super I> rPredicate;
    private final Function<? super I, ? extends O> rTrueFunction;
    private final Function<? super I, ? extends O> rFalseFunction;

    public ConditionalFunction(Predicate<? super I> rPredicate, Function<? super I, O> rFunction) {
        this(rPredicate, rFunction, null);
    }

    public ConditionalFunction(Predicate<? super I> rPredicate, Function<? super I, ? extends O> rTrueFunction, Function<? super I, ? extends O> rFalseFunction) {
        super("IF");
        assert (rPredicate != null && rTrueFunction != null);
        this.rPredicate = rPredicate;
        this.rTrueFunction = rTrueFunction;
        this.rFalseFunction = rFalseFunction;
    }

    public Function<I, O> elseDo(Function<? super I, ? extends O> rFunction) {
        return new ConditionalFunction<I, O>(this.rPredicate, this.rTrueFunction, rFunction);
    }

    @Override
    public O evaluate(I rInput) {
        O rResult = null;
        if (((Boolean)this.rPredicate.evaluate(rInput)).booleanValue()) {
            rResult = this.rTrueFunction.evaluate(rInput);
        } else if (this.rFalseFunction != null) {
            rResult = this.rFalseFunction.evaluate(rInput);
        }
        return rResult;
    }

    @Override
    public String toString() {
        return "IF " + this.rPredicate + " DO " + this.rTrueFunction + " ELSE " + (this.rFalseFunction != null ? this.rFalseFunction : "value=NULL");
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        boolean bEqual;
        ConditionalFunction rOtherFunction = (ConditionalFunction)rOther;
        boolean bl = bEqual = this.rPredicate.equals(rOtherFunction.rPredicate) && this.rTrueFunction.equals(rOtherFunction.rTrueFunction);
        if (bEqual) {
            bEqual = this.rFalseFunction != null ? this.rFalseFunction.equals(rOtherFunction.rFalseFunction) : rOtherFunction.rFalseFunction == null;
        }
        return bEqual;
    }

    @Override
    protected int paramsHashCode() {
        int nHashCode = this.rPredicate.hashCode();
        nHashCode = nHashCode * 31 + this.rTrueFunction.hashCode();
        nHashCode = nHashCode * 31 + (this.rFalseFunction != null ? this.rFalseFunction.hashCode() : 0);
        return nHashCode;
    }
}

