/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.function.AbstractFunction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CreateHash
extends AbstractFunction<byte[], byte[]> {
    private final MessageDigest aDigest;
    private final String sSalt;
    private final int nRounds;

    public CreateHash(String sAlgorithm, String sSalt, int nRounds) throws NoSuchAlgorithmException {
        super(String.format(CreateHash.class.getSimpleName() + "[%s]", sAlgorithm));
        this.aDigest = MessageDigest.getInstance(sAlgorithm);
        this.sSalt = sSalt;
        this.nRounds = nRounds;
    }

    @Override
    public byte[] evaluate(byte[] rInput) {
        byte[] aResult = rInput;
        this.aDigest.reset();
        if (this.sSalt != null) {
            this.aDigest.update(this.sSalt.getBytes());
        }
        for (int i = 0; i < this.nRounds; ++i) {
            aResult = this.aDigest.digest(aResult);
        }
        return aResult;
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        CreateHash rOtherHash = (CreateHash)rOther;
        return this.nRounds == rOtherHash.nRounds && this.sSalt.equals(rOtherHash.sSalt) && this.aDigest.getAlgorithm().equals(rOtherHash.aDigest.getAlgorithm());
    }

    @Override
    protected int paramsHashCode() {
        return this.nRounds + (37 * this.sSalt.hashCode() + 37 * this.aDigest.getAlgorithm().hashCode());
    }
}

