/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.expression.function.AbstractFunction;

public class DualFunctionChain<L, R, V, W, O>
extends AbstractBinaryFunction<L, R, O> {
    private static final String RIGHT_FUNCTION_PLACEHOLDER = "$$";
    private final BinaryFunction<V, W, O> rOuter;
    private final Function<L, ? extends V> rLeft;
    private final Function<R, ? extends W> rRight;

    public DualFunctionChain(BinaryFunction<V, W, O> rOuter, Function<L, ? extends V> rLeft, Function<R, ? extends W> rRight) {
        super(null, RIGHT_FUNCTION_PLACEHOLDER);
        this.rOuter = rOuter;
        this.rLeft = rLeft;
        this.rRight = rRight;
    }

    @Override
    public O evaluate(L rLeftValue, R rRightValue) {
        return this.rOuter.evaluate(this.rLeft.evaluate(rLeftValue), this.rRight.evaluate(rRightValue));
    }

    public final Function<V, O> getLeft() {
        return this.rOuter;
    }

    public BinaryFunction<V, W, O> getOuter() {
        return this.rOuter;
    }

    public final Function<L, ? extends V> getRight() {
        return this.rLeft;
    }

    @Override
    public String toString() {
        return this.rOuter.toString().replace("#", this.rLeft.toString()).replace(RIGHT_FUNCTION_PLACEHOLDER, this.rRight.toString());
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        DualFunctionChain rOtherFunction = (DualFunctionChain)rOther;
        return this.rOuter.equals(rOtherFunction.rLeft) && this.rLeft.equals(rOtherFunction.rRight);
    }

    @Override
    protected int paramsHashCode() {
        return 31 * (31 * this.rOuter.hashCode() + this.rLeft.hashCode()) + this.rRight.hashCode();
    }
}

