/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.function.AbstractFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FunctionGroup<I>
extends AbstractFunction<I, I> {
    private List<Function<? super I, ?>> aFunctions;

    public FunctionGroup(List<Function<? super I, ?>> rFunctions) {
        super("FunctionGroup");
        this.aFunctions = rFunctions;
    }

    @SafeVarargs
    public static <I> FunctionGroup<I> of(Function<? super I, ?> fFirst, Function<? super I, ?> ... rAdditionalFunctions) {
        ArrayList aFunctions = new ArrayList();
        aFunctions.add(fFirst);
        if (rAdditionalFunctions != null && rAdditionalFunctions.length > 0) {
            aFunctions.addAll(Arrays.asList(rAdditionalFunctions));
        }
        return new FunctionGroup<I>(aFunctions);
    }

    @Override
    public I evaluate(I rInput) {
        for (Function<I, ?> rFunction : this.aFunctions) {
            rFunction.evaluate(rInput);
        }
        return rInput;
    }

    public List<Function<? super I, ?>> getFunctions() {
        return new ArrayList(this.aFunctions);
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        FunctionGroup rOtherFunction = (FunctionGroup)rOther;
        int nCount = this.aFunctions.size();
        if (nCount != rOtherFunction.aFunctions.size()) {
            return false;
        }
        for (int i = 0; i < nCount; ++i) {
            if (this.aFunctions.get(i).equals(rOtherFunction.aFunctions.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int paramsHashCode() {
        int nHashCode = 17;
        for (Function<I, ?> rFunction : this.aFunctions) {
            nHashCode = nHashCode * 31 + rFunction.hashCode();
        }
        return nHashCode;
    }
}

