/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.expression.function.AbstractFunction;
import java.io.OutputStream;
import java.io.PrintWriter;

public class Print<I>
extends AbstractBinaryFunction<I, PrintWriter, I> {
    private final String sFormat;
    private final boolean bWithLinefeed;

    public Print(String sFormat) {
        this(System.out, sFormat, true);
    }

    public Print(OutputStream rOut, String sFormat, boolean bWithLinefeed) {
        this(new PrintWriter(rOut, true), sFormat, bWithLinefeed);
    }

    public Print(PrintWriter rWriter, String sFormat, boolean bWithLinefeed) {
        super(rWriter, bWithLinefeed ? "println" : "print");
        this.sFormat = sFormat;
        this.bWithLinefeed = bWithLinefeed;
    }

    @Override
    public I evaluate(I rInput, PrintWriter rWriter) {
        rWriter.print(String.format(this.sFormat, rInput));
        if (this.bWithLinefeed) {
            rWriter.println();
        }
        rWriter.flush();
        return rInput;
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        Print rOtherPrint = (Print)rOther;
        return this.bWithLinefeed == rOtherPrint.bWithLinefeed && this.sFormat.equals(rOtherPrint.sFormat) && super.paramsEqual(rOther);
    }

    @Override
    protected int paramsHashCode() {
        return (super.paramsHashCode() * 37 + this.sFormat.hashCode()) * 37 + (this.bWithLinefeed ? 1 : 0);
    }
}

