/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.function.AbstractBinaryFunction;
import java.util.List;
import java.util.Map;
import org.obrel.core.Relatable;
import org.obrel.core.RelationType;

public abstract class SetElement<T, E, V>
extends AbstractBinaryFunction<T, V, T> {
    private final E rElementDescriptor;

    public SetElement(E rElementDescriptor, V rValue, String sDescription) {
        super(rValue, sDescription);
        this.rElementDescriptor = rElementDescriptor;
    }

    @Override
    public final T evaluate(T rObject, V rValue) {
        this.setElementValue(this.rElementDescriptor, rObject, rValue);
        return rObject;
    }

    protected abstract void setElementValue(E var1, T var2, V var3);

    public static class SetRelationValue<T extends Relatable, V>
    extends SetElement<T, RelationType<V>, V> {
        public SetRelationValue(RelationType<V> rType, V rValue) {
            super(rType, rValue, "SetRelationValue");
        }

        @Override
        protected void setElementValue(RelationType<V> rType, T rObject, V rValue) {
            rObject.set(rType, rValue);
        }
    }

    public static class SetMapValue<K, V>
    extends SetElement<Map<K, V>, K, V> {
        public SetMapValue(K rKey, V rValue) {
            super(rKey, rValue, "SetMapValue");
        }

        @Override
        protected void setElementValue(K rKey, Map<K, V> rMap, V rValue) {
            rMap.put(rKey, rValue);
        }
    }

    public static class SetListElement<V>
    extends SetElement<List<V>, Integer, V> {
        public SetListElement(int nIndex, V rValue) {
            super(nIndex, rValue, "SetListElement");
        }

        @Override
        protected void setElementValue(Integer rIndex, List<V> rList, V rValue) {
            rList.set(rIndex, rValue);
        }
    }
}

