/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.function.AbstractFunction;
import de.esoco.lib.reflect.ReflectUtil;
import de.esoco.lib.text.TextUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenStringFormat<T>
extends AbstractFunction<T, String> {
    private static Map<String, Token<Object>> aTokenRegistry = new HashMap<String, Token<Object>>();
    static final Pattern PROPERTY_METHOD_PATTERN;
    static final Pattern FORMAT_PATTERN;
    private String sTargetPattern;
    private List<Token<? super T>> aTokens = new ArrayList<Token<? super T>>();

    public TokenStringFormat(String sTokenString) {
        super("");
        this.parseTokenString(sTokenString);
    }

    public static String format(String sTokenString, Object rValue) {
        return new TokenStringFormat(sTokenString).evaluate(rValue);
    }

    public static void registerToken(String sToken, Token<Object> rToken) {
        aTokenRegistry.put(sToken, rToken);
    }

    @Override
    public String evaluate(T rInput) {
        StringBuilder sb = new StringBuilder(this.sTargetPattern);
        for (Token<T> rToken : this.aTokens) {
            String sToken = rToken.toString();
            String sElem = rToken.transform(rInput);
            int nStart = sb.indexOf(sToken);
            int nEnd = nStart + sToken.length();
            sb.replace(nStart, nEnd, sElem != null ? sElem : "");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.sTargetPattern + "](" + "#" + ")";
    }

    protected Token<? super T> getToken(String sToken) {
        return aTokenRegistry.get(sToken);
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        TokenStringFormat rOtherFunction = (TokenStringFormat)rOther;
        return this.sTargetPattern.equals(rOtherFunction.sTargetPattern) && this.aTokens.equals(rOtherFunction.aTokens);
    }

    @Override
    protected int paramsHashCode() {
        return 31 * this.sTargetPattern.hashCode() + this.aTokens.hashCode();
    }

    protected Token<? super T> parseToken(String sToken, String sTokenFormat) {
        Matcher aMethodMatcher = PROPERTY_METHOD_PATTERN.matcher(sToken);
        PropertyToken rToken = null;
        if (aMethodMatcher.matches()) {
            String sMethod = aMethodMatcher.group(1);
            String sArguments = aMethodMatcher.group(2);
            Object[] aArgs = null;
            if (sArguments.length() > 0) {
                String[] aArgStrings = sArguments.split(",");
                aArgs = new Object[aArgStrings.length];
                for (int i = 0; i < aArgs.length; ++i) {
                    aArgs[i] = TextUtil.parseObject(aArgStrings[i]);
                }
            }
            rToken = new PropertyToken(this, sMethod, null, aArgs);
        } else {
            rToken = this.getToken(sToken);
        }
        if (rToken == null) {
            throw new IllegalArgumentException("Invalid token: " + sToken);
        }
        if (sTokenFormat != null) {
            if (sTokenFormat.length() > 0) {
                rToken = rToken.copy();
                rToken.setFormat(sTokenFormat);
            } else {
                throw new IllegalArgumentException("Empty format string");
            }
        }
        return rToken;
    }

    private void parseTokenString(String sTokenString) {
        StringBuilder sb = new StringBuilder();
        int nLength = sTokenString.length();
        int nTextStart = 0;
        int nStart = 0;
        int nEnd = 0;
        while ((nStart = sTokenString.indexOf(123, nStart)) >= 0) {
            String sToken;
            char c;
            String sTokenFormat = null;
            int nSubCount = 0;
            int nFormatPos = -1;
            block6: for (nEnd = ++nStart; nEnd < nLength && ((c = sTokenString.charAt(nEnd)) != '}' || nSubCount > 0); ++nEnd) {
                switch (c) {
                    case '{': {
                        ++nSubCount;
                        continue block6;
                    }
                    case '}': {
                        --nSubCount;
                        continue block6;
                    }
                    case ':': {
                        if (nFormatPos != -1) continue block6;
                        nFormatPos = nEnd;
                    }
                }
            }
            if (nEnd == nLength || nFormatPos == nEnd) {
                throw new IllegalArgumentException("Incomplete token: " + sTokenString);
            }
            if (nFormatPos > 0) {
                sToken = sTokenString.substring(nStart, nFormatPos);
                sTokenFormat = sTokenString.substring(nFormatPos + 1, nEnd);
            } else {
                sToken = sTokenString.substring(nStart, nEnd);
            }
            Token<T> rToken = this.parseToken(sToken, sTokenFormat);
            this.aTokens.add(rToken);
            sb.append(sTokenString.substring(nTextStart, nStart - 1));
            sb.append(rToken.toString());
            nTextStart = nStart = nEnd + 1;
        }
        sb.append(sTokenString.substring(nTextStart));
        this.sTargetPattern = sb.toString();
    }

    static {
        TokenStringFormat.registerToken("now", new Token<Object>("now"){

            @Override
            protected Object extractValue(Object ignore) {
                return new Date();
            }
        });
        TokenStringFormat.registerToken("#", new Token<Object>("#"){

            @Override
            protected Object extractValue(Object rInput) {
                return rInput;
            }
        });
        PROPERTY_METHOD_PATTERN = Pattern.compile("(\\w+?)\\((.*)\\)");
        FORMAT_PATTERN = Pattern.compile("(?s)(\\d*)([&FDNC])(.+)");
    }

    public static class PropertyToken
    extends Token<Object> {
        private Method rMethod = null;
        private Object[] rArgs = null;

        public PropertyToken(String sPropertyMethod) {
            super(sPropertyMethod);
        }

        public PropertyToken(String sPropertyMethod, String sFormat, Object ... rArgs) {
            this(null, sPropertyMethod, sFormat, rArgs);
        }

        public PropertyToken(TokenStringFormat<?> rParent, String sPropertyMethod, String sFormat, Object ... rArgs) {
            super(rParent, sPropertyMethod, sFormat);
            this.rArgs = rArgs;
        }

        @Override
        public Object extractValue(Object rInput) {
            if (this.rMethod == null) {
                String sMethod = this.getTokenString();
                Class<?>[] aArgTypes = ReflectUtil.getArgumentTypes(this.rArgs, true);
                try {
                    this.rMethod = rInput.getClass().getMethod(sMethod, aArgTypes);
                }
                catch (Exception e) {
                    String sErr = "Method <" + sMethod + "(" + Arrays.asList(aArgTypes) + ")> not found in " + rInput.getClass();
                    throw new IllegalArgumentException(sErr, e);
                }
            }
            return ReflectUtil.invoke(rInput, this.rMethod, this.rArgs);
        }
    }

    public static abstract class Token<T>
    implements Cloneable {
        private TokenStringFormat<?> rParent;
        private String sToken;
        private Object rFormatObject = null;
        private int nArrayElementCount = -1;

        protected Token(String sToken) {
            this(sToken, null);
        }

        protected Token(String sToken, String sFormat) {
            this(null, sToken, sFormat);
        }

        protected Token(TokenStringFormat<?> rParent, String sToken, String sFormat) {
            this.rParent = rParent;
            this.sToken = sToken;
            if (sFormat != null) {
                this.rFormatObject = this.parseFormat(sFormat);
            }
        }

        public final Object getFormatObject() {
            return this.rFormatObject;
        }

        public final String getTokenString() {
            return this.sToken;
        }

        public String toString() {
            return "{" + this.sToken + "}";
        }

        public final String transform(T rInput) {
            String sResult;
            Object[] rValue = this.extractValue(rInput);
            if (!(this.rFormatObject instanceof TokenStringFormat) && (rValue.getClass().isArray() || rValue instanceof Collection)) {
                if (rValue instanceof Collection) {
                    rValue = ((Collection)rValue).toArray();
                }
                StringBuilder aBuilder = new StringBuilder();
                int nCount = Array.getLength(rValue);
                if (this.nArrayElementCount > 0) {
                    nCount = Math.min(nCount, this.nArrayElementCount);
                }
                for (int i = 0; i < nCount; ++i) {
                    aBuilder.append(this.applyFormat(Array.get(rValue, i)));
                    if (this.rFormatObject != null) continue;
                    aBuilder.append(',');
                }
                if (this.rFormatObject == null && nCount > 0) {
                    aBuilder.setLength(aBuilder.length() - 1);
                }
                sResult = aBuilder.toString();
            } else {
                sResult = this.applyFormat(rValue);
            }
            return sResult;
        }

        protected abstract Object extractValue(T var1);

        protected String applyFormat(Object rValue) {
            if (this.rFormatObject instanceof String) {
                return String.format((String)this.rFormatObject, rValue);
            }
            if (this.rFormatObject instanceof TokenStringFormat) {
                return ((TokenStringFormat)this.rFormatObject).evaluate(rValue);
            }
            if (this.rFormatObject instanceof Format) {
                return ((Format)this.rFormatObject).format(rValue);
            }
            if (rValue != null) {
                return rValue.toString();
            }
            return "null";
        }

        protected Object parseFormat(String sFormat) {
            Matcher aFormatMatcher = FORMAT_PATTERN.matcher(sFormat);
            TokenStringFormat<Object> rFormat = null;
            if (aFormatMatcher.matches()) {
                String sCount = aFormatMatcher.group(1);
                String sType = aFormatMatcher.group(2);
                if (sCount.length() > 0) {
                    this.nArrayElementCount = Integer.parseInt(sCount);
                }
                sFormat = aFormatMatcher.group(3);
                switch (sType.charAt(0)) {
                    case '&': {
                        if (this.rParent != null) {
                            rFormat = ReflectUtil.newInstance(this.rParent.getClass(), new Object[]{sFormat}, null);
                            break;
                        }
                        rFormat = new TokenStringFormat(sFormat);
                        break;
                    }
                    case 'F': {
                        rFormat = sFormat;
                        break;
                    }
                    case 'D': {
                        rFormat = new SimpleDateFormat(sFormat);
                        break;
                    }
                    case 'N': {
                        rFormat = new DecimalFormat(sFormat);
                        break;
                    }
                    case 'C': {
                        rFormat = new ChoiceFormat(sFormat);
                    }
                }
            }
            if (rFormat == null) {
                throw new IllegalArgumentException("Invalid format string: " + sFormat);
            }
            return rFormat;
        }

        protected final void setFormatObject(Object rFormatObject) {
            this.rFormatObject = rFormatObject;
        }

        final Token<T> copy() {
            try {
                return (Token)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        final void setFormat(String sFormatString) {
            this.rFormatObject = this.parseFormat(sFormatString);
        }
    }
}

