/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.predicate;

import de.esoco.lib.expression.predicate.AbstractBinaryPredicate;

public abstract class ClassPredicate<T>
extends AbstractBinaryPredicate<T, Class<?>> {
    public ClassPredicate(Class<?> rClass, String sToken) {
        super(rClass, sToken);
    }

    @Override
    public final Boolean evaluate(T rTarget, Class<?> rClass) {
        return rTarget != null && this.checkClass(rTarget.getClass(), rClass);
    }

    public final Class<?> getCheckedClass() {
        return (Class)this.getRightValue();
    }

    protected abstract boolean checkClass(Class<?> var1, Class<?> var2);

    public static class HasClass<T>
    extends ClassPredicate<T> {
        public HasClass(Class<?> rClass) {
            super(rClass, "HasClass");
        }

        @Override
        protected boolean checkClass(Class<?> rCheckClass, Class<?> rClass) {
            return rCheckClass == rClass;
        }
    }

    public static class HasBaseClass<T>
    extends ClassPredicate<T> {
        public HasBaseClass(Class<?> rClass) {
            super(rClass, "HasBaseClass");
        }

        @Override
        protected boolean checkClass(Class<?> rCheckClass, Class<?> rClass) {
            return rClass.isAssignableFrom(rCheckClass);
        }
    }
}

