/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.predicate;

import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.function.AbstractFunction;
import de.esoco.lib.expression.predicate.AbstractPredicate;

public class FunctionPredicate<T, V>
extends AbstractPredicate<T> {
    private final Function<? super T, V> rFunction;
    private final Predicate<? super V> rPredicate;

    public FunctionPredicate(Function<? super T, V> rFunction, Predicate<? super V> rPredicate) {
        super("");
        if (rFunction == null) {
            throw new IllegalArgumentException("Function must not be NULL");
        }
        if (rPredicate == null) {
            throw new IllegalArgumentException("Predicate must not be NULL");
        }
        this.rFunction = rFunction;
        this.rPredicate = rPredicate;
    }

    @Override
    public Boolean evaluate(T rObject) {
        return (Boolean)this.rPredicate.evaluate(this.rFunction.evaluate(rObject));
    }

    public final Function<? super T, V> getFunction() {
        return this.rFunction;
    }

    public final Predicate<? super V> getPredicate() {
        return this.rPredicate;
    }

    @Override
    public String toString() {
        return this.rPredicate.toString().replace("#", this.rFunction.toString());
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        FunctionPredicate rOtherPredicate = (FunctionPredicate)rOther;
        return this.rPredicate.equals(rOtherPredicate.rPredicate) && this.rFunction.equals(rOtherPredicate.rFunction);
    }

    @Override
    protected int paramsHashCode() {
        return 31 * this.rPredicate.hashCode() + this.rFunction.hashCode();
    }
}

