/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.predicate;

import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.function.AbstractFunction;
import de.esoco.lib.expression.predicate.AbstractPredicate;

public abstract class PredicateJoin<T>
extends AbstractPredicate<T> {
    private final Predicate<? super T> rLeft;
    private final Predicate<? super T> rRight;
    private final String sJoinToken;

    public PredicateJoin(Predicate<? super T> rLeft, Predicate<? super T> rRight, String sJoinToken) {
        super("");
        if (rLeft == null || rRight == null) {
            throw new IllegalArgumentException("Predicates must not be NULL");
        }
        this.rLeft = rLeft;
        this.rRight = rRight;
        this.sJoinToken = sJoinToken;
    }

    @Override
    public final Boolean evaluate(T rValue) {
        return this.evaluate(this.rLeft, this.rRight, rValue);
    }

    public final Predicate<? super T> getLeft() {
        return this.rLeft;
    }

    public final Predicate<? super T> getRight() {
        return this.rRight;
    }

    @Override
    public String toString() {
        return "(" + this.rLeft + " " + this.sJoinToken + " " + this.rRight + ")";
    }

    protected abstract Boolean evaluate(Predicate<? super T> var1, Predicate<? super T> var2, T var3);

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        PredicateJoin rOtherPredicate = (PredicateJoin)rOther;
        return this.rLeft.equals(rOtherPredicate.rLeft) && this.rRight.equals(rOtherPredicate.rRight);
    }

    @Override
    protected int paramsHashCode() {
        return 31 * this.rLeft.hashCode() + this.rRight.hashCode();
    }
}

