/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.json;

import de.esoco.lib.text.TextConvert;
import de.esoco.lib.text.TextUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;

public class JsonUtil {
    public static final DateFormat JSON_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    private JsonUtil() {
    }

    public static void appendCollection(StringBuilder rJsonData, Collection<?> rCollection) {
        rJsonData.append("[");
        for (Object rElement : rCollection) {
            JsonUtil.appendValue(rJsonData, rElement);
            rJsonData.append(", ");
        }
        if (!rCollection.isEmpty()) {
            rJsonData.setLength(rJsonData.length() - 2);
        }
        rJsonData.append(']');
    }

    public static void appendMap(StringBuilder rJsonData, Map<?, ?> rMap) {
        if (!rMap.isEmpty()) {
            rJsonData.append("{\n");
            for (Map.Entry<?, ?> rEntry : rMap.entrySet()) {
                JsonUtil.appendName(rJsonData, rEntry.getKey().toString());
                JsonUtil.appendValue(rJsonData, rEntry.getValue());
                rJsonData.append(",\n");
            }
            rJsonData.setLength(rJsonData.length() - 2);
            rJsonData.append("\n}");
        } else {
            rJsonData.append("{}");
        }
    }

    public static void appendName(StringBuilder rJsonData, String sName) {
        rJsonData.append('\"');
        rJsonData.append(sName);
        rJsonData.append("\": ");
    }

    public static boolean appendRelation(StringBuilder rJsonData, Relation<?> rRelation, boolean bWithNamespace, boolean bAppendNullValues) {
        boolean bHasValue;
        Object rValue = rRelation.getTarget();
        boolean bl = bHasValue = rValue != null || bAppendNullValues;
        if (bHasValue) {
            RelationType<?> rRelationType = rRelation.getType();
            String sName = bWithNamespace ? rRelationType.getName() : rRelationType.getSimpleName();
            JsonUtil.appendName(rJsonData, sName);
            JsonUtil.appendValue(rJsonData, rValue);
        }
        return bHasValue;
    }

    public static void appendStringValue(StringBuilder rJsonData, String sValue) {
        rJsonData.append('\"');
        JsonUtil.escapeJsonValue(rJsonData, sValue);
        rJsonData.append('\"');
    }

    public static void appendValue(StringBuilder rJsonData, Object rValue) {
        if (rValue == null) {
            rJsonData.append("null");
        } else {
            Class<?> rDatatype = rValue.getClass();
            if (rDatatype == Boolean.class || Number.class.isAssignableFrom(rDatatype)) {
                rJsonData.append(rValue.toString());
            } else if (Collection.class.isAssignableFrom(rDatatype)) {
                JsonUtil.appendCollection(rJsonData, (Collection)rValue);
            } else if (Map.class.isAssignableFrom(rDatatype)) {
                Map rMap = (Map)rValue;
                JsonUtil.appendMap(rJsonData, rMap);
            } else if (Date.class.isAssignableFrom(rDatatype)) {
                JsonUtil.appendStringValue(rJsonData, JSON_DATE_FORMAT.format((Date)rValue));
            } else {
                JsonUtil.appendStringValue(rJsonData, rValue.toString());
            }
        }
    }

    public static void escapeJsonValue(StringBuilder aTarget, CharSequence sOriginalValue) {
        int nLength = sOriginalValue.length();
        block10: for (int nChar = 0; nChar < nLength; ++nChar) {
            char c = sOriginalValue.charAt(nChar);
            switch (c) {
                case '\"': {
                    aTarget.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    aTarget.append("\\\\");
                    continue block10;
                }
                case '/': {
                    aTarget.append("\\/");
                    continue block10;
                }
                case '\b': {
                    aTarget.append("\\b");
                    continue block10;
                }
                case '\f': {
                    aTarget.append("\\f");
                    continue block10;
                }
                case '\n': {
                    aTarget.append("\\n");
                    continue block10;
                }
                case '\r': {
                    aTarget.append("\\r");
                    continue block10;
                }
                case '\t': {
                    aTarget.append("\\t");
                    continue block10;
                }
                default: {
                    if (TextUtil.isControlCharacter(c)) {
                        String sHexValue = Integer.toHexString(c).toUpperCase();
                        aTarget.append("\\u");
                        aTarget.append(TextConvert.padLeft((String)sHexValue, (int)4, (char)'0'));
                        continue block10;
                    }
                    aTarget.append(c);
                }
            }
        }
    }
}

