/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.text;

import de.esoco.lib.datatype.Pair;
import de.esoco.lib.text.TextConvert;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextUtil
extends TextConvert {
    private static final Pattern NON_ASCII_CHARS = Pattern.compile("[\\x80-\\xFFFF]");
    private static final Map<String, String> ASCII_REPLACE_MAP = new HashMap<String, String>();

    public static boolean containsLowerCase(CharSequence sText) {
        int l = sText.length();
        for (int i = 0; i < l; ++i) {
            if (!Character.isLowerCase(sText.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsUpperCase(CharSequence sText) {
        int l = sText.length();
        for (int i = 0; i < l; ++i) {
            if (!Character.isUpperCase(sText.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static int count(String sText, String sRegEx) {
        return TextUtil.count(sText, Pattern.compile(sRegEx));
    }

    public static int count(String sText, Pattern rRegEx) {
        Matcher aMatcher = rRegEx.matcher(sText);
        int nCount = 0;
        while (aMatcher.find()) {
            ++nCount;
        }
        return nCount;
    }

    public static Pair<Character, String> extractMnemonic(String sText) {
        StringBuilder sb = new StringBuilder(sText);
        int pos = 0;
        Character aMnemonic = null;
        while ((pos = sb.indexOf("&", pos)) != -1 && pos < sb.length() - 1) {
            char c = sb.charAt(pos + 1);
            if (Character.isWhitespace(c)) continue;
            sb.deleteCharAt(pos);
            if (aMnemonic != null || c == '&') continue;
            aMnemonic = Character.valueOf(c);
        }
        return new Pair<Object, String>(aMnemonic, sb.toString());
    }

    public static boolean isControlCharacter(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff';
    }

    public static boolean isLowerCase(CharSequence sText) {
        int l = sText.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isLowerCase(sText.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(CharSequence sText) {
        int l = sText.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isUpperCase(sText.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int nextGroup(Matcher rMatcher, int nStart) {
        int nGroups = rMatcher.groupCount();
        while (nStart <= nGroups && rMatcher.group(nStart) == null) {
            ++nStart;
        }
        return nStart <= nGroups ? nStart : -1;
    }

    public static Object parseObject(String sValue) {
        sValue = sValue.trim();
        int nLength = sValue.length();
        if (Pattern.matches("\".*\"|'.*'", sValue)) {
            return sValue.substring(1, nLength - 1);
        }
        if (Pattern.matches("-?[\\d]+", sValue)) {
            return Integer.valueOf(sValue);
        }
        if (Pattern.matches("(?i:true|false)", sValue)) {
            return Boolean.valueOf(sValue);
        }
        if (sValue.equals("null")) {
            return null;
        }
        return sValue;
    }

    public static String simplePatternToRegEx(String sPattern) {
        sPattern = sPattern.replace(".", "\\.");
        sPattern = sPattern.replace("*", ".*");
        sPattern = sPattern.replace("?", ".?");
        return sPattern;
    }

    public static String toAscii(String sString) {
        if (sString != null && NON_ASCII_CHARS.matcher(sString.toLowerCase()).find()) {
            for (Map.Entry<String, String> rReplace : ASCII_REPLACE_MAP.entrySet()) {
                sString = sString.replaceAll(rReplace.getKey(), rReplace.getValue());
            }
        }
        return sString;
    }

    static {
        ASCII_REPLACE_MAP.put("[\u00c4\u00c6]", "Ae");
        ASCII_REPLACE_MAP.put("\u00c5", "Aa");
        ASCII_REPLACE_MAP.put("[\u00d6\u00d8]", "Oe");
        ASCII_REPLACE_MAP.put("\u00dc", "Ue");
        ASCII_REPLACE_MAP.put("[\u00e4\u00e6]", "ae");
        ASCII_REPLACE_MAP.put("\u00e5", "aa");
        ASCII_REPLACE_MAP.put("[\u00f6\u00f8]", "oe");
        ASCII_REPLACE_MAP.put("\u00fc", "ue");
        ASCII_REPLACE_MAP.put("\u00df", "ss");
        ASCII_REPLACE_MAP.put("\u00c7", "C");
        ASCII_REPLACE_MAP.put("[\u00c0\u00c1\u00c2\u00c3]", "A");
        ASCII_REPLACE_MAP.put("[\u00c8\u00c9\u00ca\u00cb]", "E");
        ASCII_REPLACE_MAP.put("[\u00cc\u00cd\u00ce\u00cf]", "I");
        ASCII_REPLACE_MAP.put("[\u00d2\u00d3\u00d4\u00d5]", "O");
        ASCII_REPLACE_MAP.put("[\u00d9\u00da\u00db]", "U");
        ASCII_REPLACE_MAP.put("[\u00e0\u00e1\u00e2\u00e3]", "a");
        ASCII_REPLACE_MAP.put("\u00e7", "c");
        ASCII_REPLACE_MAP.put("[\u00e8\u00e9\u00ea\u00eb]", "e");
        ASCII_REPLACE_MAP.put("[\u00ec\u00ed\u00ee\u00ef]", "i");
        ASCII_REPLACE_MAP.put("[\u00f2\u00f3\u00f4\u00f5]", "o");
        ASCII_REPLACE_MAP.put("[\u00f9\u00fa\u00fb]", "u");
    }
}

