/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.xml;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlUtil {
    private static final String TAG_TEXT_CONTENT_NODE = "#text";

    private XmlUtil() {
    }

    public static void addTagsAsProperties(Node rNode, Map<String, String> rMap) {
        Node rChild;
        if (rNode instanceof Element && (rChild = rNode.getFirstChild()) instanceof Text) {
            rMap.put(rNode.getNodeName(), ((Text)rChild).getData());
        }
        NodeList rChildNodes = rNode.getChildNodes();
        int nCount = rChildNodes.getLength();
        for (int i = 0; i < nCount; ++i) {
            XmlUtil.addTagsAsProperties(rChildNodes.item(i), rMap);
        }
    }

    public static String evaluateXpathExpression(Document rDocument, String sXpathExpression) throws XPathExpressionException {
        XPathFactory aXpathFactory = XPathFactory.newInstance();
        XPath aXpath = aXpathFactory.newXPath();
        return aXpath.evaluate(sXpathExpression, rDocument);
    }

    public static String format(String sXML, int nIndent, boolean bWithDeclaration) {
        try {
            Transformer aTransformer = SAXTransformerFactory.newInstance().newTransformer();
            SAXSource aSource = new SAXSource(new InputSource(new ByteArrayInputStream(sXML.getBytes())));
            StringWriter aWriter = new StringWriter();
            StreamResult aResult = new StreamResult(aWriter);
            aTransformer.setOutputProperty("indent", "yes");
            aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "" + nIndent);
            aTransformer.setOutputProperty("omit-xml-declaration", bWithDeclaration ? "no" : "yes");
            aTransformer.transform(aSource, aResult);
            return aWriter.toString();
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Map<String, String> getTagsAsProperties(Node rNode) {
        LinkedHashMap<String, String> aProperties = new LinkedHashMap<String, String>();
        XmlUtil.addTagsAsProperties(rNode, aProperties);
        return aProperties;
    }

    public static String getXmlAttributeValue(Document rDocument, String sNodeTag, String sAttributeName, String sFormat) {
        Node rAttribute;
        NamedNodeMap rAttributes;
        Node rNode = XmlUtil.getXmlNode(rDocument, sNodeTag);
        String sValue = "";
        if (rNode != null && (rAttributes = rNode.getAttributes()) != null && (rAttribute = rAttributes.getNamedItem(sAttributeName)) != null) {
            sValue = rAttribute.getTextContent();
            if (sFormat != null) {
                sValue = String.format(sFormat, sValue);
            }
        }
        return sValue;
    }

    public static Node getXmlNode(Document rDocument, String sNodeTag) {
        List<Node> rNodes = XmlUtil.getXmlNodes(rDocument, sNodeTag);
        return rNodes.size() > 0 ? rNodes.get(0) : null;
    }

    public static String getXmlNodeContent(Document rDocument, String sNodeTag) {
        return XmlUtil.getXmlNodeContent(rDocument, sNodeTag, null);
    }

    public static String getXmlNodeContent(Document rDocument, String sNodeTag, String sFormat) {
        Node rNode = XmlUtil.getXmlNode(rDocument, sNodeTag);
        String sValue = "";
        if (rNode != null) {
            sValue = rNode.getTextContent();
            if (sFormat != null) {
                sValue = String.format(sFormat, sValue);
            }
        }
        return sValue;
    }

    public static List<Node> getXmlNodes(Document rDocument, String sNodeTag) {
        int nSize;
        NodeList rNodeList = rDocument.getElementsByTagName(sNodeTag);
        List<Node> rNodes = null;
        if (rNodeList != null && (nSize = rNodeList.getLength()) > 0) {
            rNodes = new ArrayList<Node>(nSize);
            for (int i = 0; i < nSize; ++i) {
                rNodes.add(rNodeList.item(i));
            }
        }
        if (rNodes == null) {
            rNodes = Collections.emptyList();
        }
        return rNodes;
    }

    public static List<String> getXmlNodesContent(Document rDocument, String sNodeTag) {
        List<Node> rNodes = XmlUtil.getXmlNodes(rDocument, sNodeTag);
        ArrayList<String> aValues = new ArrayList<String>(rNodes.size());
        for (Node rNode : rNodes) {
            aValues.add(rNode.getTextContent());
        }
        return aValues;
    }

    public static String nodeHierarchyToString(Node rNode, String sIndent, boolean bIncludeRoot) {
        return XmlUtil.nodeHierarchyToString(rNode, sIndent, bIncludeRoot, 0);
    }

    public static String toString(Node rNode) {
        try {
            DOMSource aSource = new DOMSource(rNode);
            StringWriter aOutput = new StringWriter();
            StreamResult aResult = new StreamResult(aOutput);
            Transformer aTransformer = TransformerFactory.newInstance().newTransformer();
            aTransformer.transform(aSource, aResult);
            return aOutput.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String nodeHierarchyToString(Node rNode, String sIndent, boolean bIncludeRoot, int nLevel) {
        int nChildCount;
        String sNodeName = rNode.getNodeName();
        NamedNodeMap rAttributes = rNode.getAttributes();
        NodeList rChildNodes = rNode.getChildNodes();
        StringBuilder aResult = new StringBuilder();
        int n = nChildCount = rChildNodes != null ? rChildNodes.getLength() : 0;
        if (bIncludeRoot) {
            int i;
            if (sNodeName != null) {
                sNodeName = sNodeName.replace(':', '-');
            }
            int nAttrCount = rAttributes != null ? rAttributes.getLength() : 0;
            for (i = 0; i < nLevel; ++i) {
                aResult.append(sIndent);
            }
            aResult.append(sNodeName);
            for (i = 0; i < nAttrCount; ++i) {
                Node rAttribute = rAttributes.item(i);
                aResult.append(" ");
                aResult.append(rAttribute.getNodeName());
                aResult.append("=");
                aResult.append(rAttribute.getNodeValue());
            }
            if (nChildCount == 1 && TAG_TEXT_CONTENT_NODE.equals(rChildNodes.item(0).getNodeName())) {
                String sContent = rNode.getTextContent();
                aResult.append(": ");
                aResult.append(sContent);
            } else if (nChildCount > 0) {
                aResult.append(": ");
            }
            aResult.append('\n');
            ++nLevel;
        }
        for (int i = 0; i < nChildCount; ++i) {
            Node rChild = rChildNodes.item(i);
            if (TAG_TEXT_CONTENT_NODE.equals(rChild.getNodeName())) continue;
            aResult.append(XmlUtil.nodeHierarchyToString(rChild, sIndent, true, nLevel));
        }
        return aResult.toString();
    }
}

