/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.expression.Function;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.obrel.core.DirectRelation;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;

public class IntermediateRelation<T, I>
extends DirectRelation<T> {
    private static final long serialVersionUID = 1L;
    static final RelationType<Function<?, ?>> TARGET_CONVERSION = RelationTypes.newType(RelationTypeModifier.PRIVATE);
    static final RelationType<Object> INTERMEDIATE_TARGET = RelationTypes.newType(RelationTypeModifier.PRIVATE);

    IntermediateRelation(RelationType<T> rType, Function<I, T> fTargetConversion, I rIntermediateTarget) {
        super(rType, null);
        assert (fTargetConversion != null);
        assert (rIntermediateTarget != null);
        this.set(TARGET_CONVERSION, fTargetConversion);
        this.set(INTERMEDIATE_TARGET, rIntermediateTarget);
    }

    public final I getIntermediateTarget() {
        return (I)this.get(INTERMEDIATE_TARGET);
    }

    @Override
    public T getTarget() {
        Object rTarget = super.getTarget();
        Function<?, ?> fConversion = this.get(TARGET_CONVERSION);
        if (fConversion != null && rTarget == null) {
            rTarget = fConversion.evaluate(this.get(INTERMEDIATE_TARGET));
            this.setTarget(rTarget);
        }
        return rTarget;
    }

    @Override
    boolean dataEqual(Relation<?> rOther) {
        this.getTarget();
        return super.dataEqual(rOther);
    }

    @Override
    int dataHashCode() {
        this.getTarget();
        return super.dataHashCode();
    }

    @Override
    void setTarget(T rNewTarget) {
        this.deleteRelation(TARGET_CONVERSION);
        this.deleteRelation(INTERMEDIATE_TARGET);
        super.setTarget(rNewTarget);
    }

    private void writeObject(ObjectOutputStream rOut) throws IOException {
        if (!(this.get(TARGET_CONVERSION) instanceof Serializable) || !(this.get(INTERMEDIATE_TARGET) instanceof Serializable)) {
            this.getTarget();
        }
        rOut.defaultWriteObject();
    }

    static {
        RelationTypes.init(IntermediateRelation.class);
    }
}

