/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.expression.predicate.AbstractPredicate;
import de.esoco.lib.json.JsonUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypes;
import org.obrel.type.MetaTypes;
import org.obrel.type.StandardTypes;

public class ObjectRelations {
    private static final RelatedObject EMPTY_RELATION_CONTAINER = new RelatedObject();
    private static Map<Object, RelatedObject> aRelationContainerMap = new WeakHashMap<Object, RelatedObject>();

    private ObjectRelations() {
    }

    public static void copyRelations(Relatable rSource, Relatable rTarget, boolean bReplace) {
        ((RelatedObject)rTarget).copyRelations((RelatedObject)rSource, bReplace);
    }

    public static Relatable getRelatable(Object rForObject) {
        return ObjectRelations.getRelationContainer(rForObject, true);
    }

    public static void init() {
        ObjectRelations.registerRelationTypes(RelationTypes.class, MetaTypes.class, StandardTypes.class);
    }

    public static void registerRelationTypes(Class<?> ... rClasses) {
        assert (rClasses.length > 0) : "No classes to register";
        for (Class<?> rClass : rClasses) {
            try {
                Class.forName(rClass.getName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static void removeRelatable(Object rForObject) {
        aRelationContainerMap.remove(rForObject);
    }

    public static <T> void setAll(RelationType<T> rType, T rTarget, Relatable ... rObjects) {
        for (Relatable rObject : rObjects) {
            rObject.set(rType, rTarget);
        }
    }

    public static void setFlags(RelationType<Boolean> rFlagType, Relatable ... rObjects) {
        ObjectRelations.setAll(rFlagType, Boolean.TRUE, rObjects);
    }

    public static void shutdown() {
        aRelationContainerMap.clear();
    }

    public static void swapRelations(RelatedObject rFirst, RelatedObject rSecond) {
        Map<RelationType<?>, Relation<?>> rSecondRelations = rSecond.aRelations;
        rSecond.aRelations = rFirst.aRelations;
        rFirst.aRelations = rSecondRelations;
    }

    public static void syncRelations(RelatedObject rTarget, RelatedObject rSource) {
        rTarget.aRelations = rSource.aRelations;
    }

    public static String toJson(Relatable rObject, final Collection<RelationType<?>> rRelationTypes) {
        StringBuilder aJson = new StringBuilder("{\n");
        AbstractPredicate pRelations = null;
        if (rRelationTypes != null) {
            pRelations = new AbstractPredicate<Relation<?>>("JsonRelationType"){

                @Override
                public Boolean evaluate(Relation<?> rRelation) {
                    return rRelationTypes.contains(rRelation.getType());
                }
            };
        }
        List<Relation<?>> rRelations = rObject.getRelations(pRelations);
        for (Relation<?> rRelation : rRelations) {
            JsonUtil.appendRelation(aJson, rRelation, true, false);
            aJson.append(",\n");
        }
        if (!rRelations.isEmpty()) {
            aJson.setLength(aJson.length() - 2);
        }
        aJson.append("\n}");
        return aJson.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RelatedObject getRelationContainer(Object rObject, boolean bCreate) {
        if (rObject instanceof RelatedObject) {
            return (RelatedObject)rObject;
        }
        Map<Object, RelatedObject> map = aRelationContainerMap;
        synchronized (map) {
            RelatedObject rContainer = aRelationContainerMap.get(rObject);
            if (rContainer == null) {
                if (bCreate) {
                    rContainer = new RelatedObject();
                    aRelationContainerMap.put(rObject, rContainer);
                } else {
                    rContainer = EMPTY_RELATION_CONTAINER;
                }
            }
            return rContainer;
        }
    }
}

