/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.event.EventHandler;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import org.obrel.core.ObjectRelations;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationAlias;
import org.obrel.core.RelationEvent;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;
import org.obrel.core.RelationView;
import org.obrel.core.RelationWrapper;
import org.obrel.core.SerializableRelatedObject;
import org.obrel.type.MetaTypes;
import org.obrel.type.StandardTypes;

public abstract class Relation<T>
extends SerializableRelatedObject {
    private static final long serialVersionUID = 1L;
    static final RelationType<List<RelationWrapper<?>>> ALIASES = RelationTypes.newListType(RelationTypeModifier.PRIVATE);
    private final RelationType<T> rType;

    Relation(RelationType<T> rType) {
        this.rType = rType;
    }

    static void checkValidTargetForType(RelationType<?> rType, Object rTarget) {
        if (!Relation.isValidTargetForType(rType, rTarget)) {
            throw new IllegalArgumentException(String.format("Invalid target for type '%s': %s (is %s - expected %s)", rType, rTarget, rTarget.getClass().getName(), rType.getTargetType()));
        }
    }

    static boolean isValidTargetForType(RelationType<?> rType, Object rTarget) {
        assert (rType != null);
        return rTarget == null || rType.getTargetType().isAssignableFrom(rTarget.getClass());
    }

    public abstract T getTarget();

    public void addUpdateListener(EventHandler<RelationEvent<T>> rListener) {
        this.get(StandardTypes.RELATION_UPDATE_LISTENERS).add(rListener);
    }

    public final void aliasAs(RelationType<T> rAliasType, Relatable rInParent) {
        this.addAlias(new RelationAlias<T>(rAliasType, this), rInParent);
    }

    public final Relation<T> annotate(RelationType<Boolean> rAnnotationType) {
        return this.annotate(rAnnotationType, Boolean.TRUE);
    }

    public final <V> Relation<T> annotate(RelationType<V> rAnnotationType, V rValue) {
        this.set(rAnnotationType, rValue);
        return this;
    }

    public final boolean equals(Object rObject) {
        if (this == rObject) {
            return true;
        }
        if (rObject == null || this.getClass() != rObject.getClass()) {
            return false;
        }
        Relation rOther = (Relation)rObject;
        return this.rType == rOther.rType && this.dataEqual(rOther) && this.relationsEqual(rOther);
    }

    public final <V> V getAnnotation(RelationType<V> rAnnotationType) {
        Object rValue = this.hasRelation(rAnnotationType) ? this.get(rAnnotationType) : (this.rType.hasRelation(rAnnotationType) ? this.rType.get(rAnnotationType) : null);
        return rValue;
    }

    public final RelationType<T> getType() {
        return this.rType;
    }

    public final boolean hasAnnotation(RelationType<?> rAnnotationType) {
        return this.hasRelation(rAnnotationType) || this.rType.hasRelation(rAnnotationType);
    }

    public final boolean hasFlagAnnotation(RelationType<Boolean> rAnnotationType) {
        Boolean rFlag = this.getAnnotation(rAnnotationType);
        return rFlag != null ? rFlag : false;
    }

    public final int hashCode() {
        int nResult = this.rType.hashCode();
        nResult = 31 * nResult + this.dataHashCode();
        nResult = 31 * nResult + this.relationsHashCode();
        return nResult;
    }

    @Override
    public String toString() {
        return "Relation[" + this.rType + "=" + this.getTarget() + "]";
    }

    public final void viewAs(RelationType<? super T> rViewType, Relatable rInParent) {
        this.addAlias(new RelationView<T>(this, rViewType), rInParent);
    }

    abstract Relation<T> copy();

    abstract boolean dataEqual(Relation<?> var1);

    abstract int dataHashCode();

    abstract void setTarget(T var1);

    final void addAlias(RelationWrapper<?> rAlias, Relatable rInParent) {
        ObjectRelations.getRelationContainer(rInParent, true).addRelation(rAlias, true);
        this.get(ALIASES).add(rAlias);
    }

    void copyTo(RelatedObject rTarget, boolean bReplace) {
        Relation<T> aCopy;
        boolean bExists = rTarget.hasRelation(this.rType);
        if (this.rType != ALIASES && (!bExists || bReplace && !this.rType.isFinal()) && (aCopy = this.copy()) != null) {
            aCopy.copyRelations(this, bReplace);
            rTarget.addRelation(aCopy, true);
            for (RelationWrapper<?> rAlias : this.get(ALIASES)) {
                RelationType<T> rAliasType = rAlias.getType();
                if (rAlias instanceof RelationAlias) {
                    aCopy.aliasAs(rAliasType, rTarget);
                    continue;
                }
                aCopy.viewAs(rAliasType, rTarget);
            }
        }
    }

    void prepareReplace(Relation<T> rOther) {
        this.transferRelationsFrom(rOther, false);
        for (RelationWrapper<?> rAlias : this.get(ALIASES)) {
            rAlias.updateWrappedRelation(this);
        }
    }

    void removed(RelatedObject rParent) {
        Iterator<RelationWrapper<?>> i = this.get(ALIASES).iterator();
        while (i.hasNext()) {
            RelationWrapper<?> rAlias = i.next();
            i.remove();
            rParent.deleteRelation(rAlias);
        }
    }

    final void updateTarget(T rNewTarget) {
        if (this.hasFlag(MetaTypes.IMMUTABLE)) {
            throw new UnsupportedOperationException("Relation is immutable: " + this.rType);
        }
        Relation.checkValidTargetForType(this.rType, rNewTarget);
        this.setTarget(rNewTarget);
    }

    private void readObject(ObjectInputStream rIn) throws IOException, ClassNotFoundException {
        rIn.defaultReadObject();
        if (this.rType == null) {
            throw new InvalidObjectException("RelationType is NULL");
        }
    }

    static {
        RelationTypes.init(Relation.class);
    }
}

