/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.filter;

import de.esoco.lib.expression.BinaryPredicate;
import de.esoco.lib.expression.CollectionPredicates;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.Predicates;
import de.esoco.lib.expression.predicate.AbstractBinaryPredicate;
import java.util.Collection;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;
import org.obrel.filter.RelationTypeFilter;

public class RelationFilters {
    public static final Predicate<Relation<?>> ALL_RELATIONS = Predicates.alwaysTrue();

    private RelationFilters() {
    }

    public static Predicate<Relation<?>> ifType(Predicate<RelationType<?>> rTypePredicate) {
        return new RelationTypeFilter(rTypePredicate);
    }

    public static BinaryPredicate<Relation<?>, Predicate<Relation<?>>> withAnnotation(Predicate<Relation<?>> rAnnotationFilter) {
        return new AbstractBinaryPredicate<Relation<?>, Predicate<Relation<?>>>(rAnnotationFilter, "Target %s", true){

            @Override
            public Boolean evaluate(Relation<?> rRelation, Predicate<Relation<?>> rAnnotationFilter) {
                return rRelation.hasRelations(rAnnotationFilter);
            }
        };
    }

    public static BinaryPredicate<Relation<?>, Predicate<Object>> withTarget(Predicate<Object> rTargetPredicate) {
        return new AbstractBinaryPredicate<Relation<?>, Predicate<Object>>(rTargetPredicate, "Target %s", true){

            @Override
            public Boolean evaluate(Relation<?> rRelation, Predicate<Object> rTargetPredicate) {
                return (Boolean)rTargetPredicate.evaluate(rRelation.getTarget());
            }
        };
    }

    public static Predicate<Relation<?>> withTypeIn(Collection<RelationType<?>> rTypes) {
        Predicate<RelationType<?>> aElementOfTypes = CollectionPredicates.elementOf(rTypes);
        return RelationFilters.ifType(aElementOfTypes);
    }
}

