/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.type;

import de.esoco.lib.event.EventDispatcher;
import de.esoco.lib.event.EventHandler;
import de.esoco.lib.expression.Action;
import de.esoco.lib.property.Immutability;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.obrel.core.Annotations;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationEvent;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;
import org.obrel.type.StandardTypes;

@Annotations.RelationTypeNamespace(value="")
public class MetaTypes {
    public static final RelationType<Class<?>> DECLARING_CLASS = RelationTypes.DECLARING_CLASS;
    public static final RelationType<Class<?>> DATATYPE = RelationTypes.newType(RelationTypeModifier.FINAL);
    public static final RelationType<Class<?>> ELEMENT_DATATYPE = RelationTypes.ELEMENT_DATATYPE;
    public static final RelationType<Class<?>> KEY_DATATYPE = RelationTypes.KEY_DATATYPE;
    public static final RelationType<Class<?>> VALUE_DATATYPE = RelationTypes.VALUE_DATATYPE;
    public static final RelationType<Boolean> OBJECT_ID_ATTRIBUTE = RelationTypes.newFlagType(RelationTypeModifier.FINAL);
    public static final RelationType<Boolean> OBJECT_TYPE_ATTRIBUTE = RelationTypes.newFlagType(RelationTypeModifier.FINAL);
    public static final RelationType<Boolean> OBJECT_NAME_ATTRIBUTE = RelationTypes.newFlagType(RelationTypeModifier.FINAL);
    public static final RelationType<Boolean> PARENT_ATTRIBUTE = RelationTypes.newFlagType(RelationTypeModifier.FINAL);
    public static final RelationType<Boolean> CHILD_ATTRIBUTE = RelationTypes.newFlagType(RelationTypeModifier.FINAL);
    public static final RelationType<Boolean> IMMUTABLE = new ImmutableFlagType();
    public static final RelationType<Boolean> MANDATORY = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> OPTIONAL = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> ORDERED = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> MANAGED = RelationTypes.newFlagType(RelationTypeModifier.FINAL);
    public static final RelationType<Boolean> UNIQUE = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> MODIFIED = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> INVALID = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> CLOSED = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> AUTOGENERATED = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> INTERACTIVE = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> INITIALIZING = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> INITIALIZED = RelationTypes.newType(RelationTypeModifier.FINAL);
    public static final RelationType<Boolean> AUTHENTICATED = RelationTypes.newType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> AUTHORIZED = RelationTypes.newType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> HIERARCHICAL = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> TRANSACTIONAL = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Boolean> SORT_ASCENDING = RelationTypes.newFlagType(new RelationTypeModifier[0]);
    public static final RelationType<Integer> SORT_ORDER = RelationTypes.newType(new RelationTypeModifier[0]);
    public static final RelationType<String> RELATION_TYPE_NAMESPACE = RelationTypes.RELATION_TYPE_NAMESPACE;
    public static final RelationType<Action<RelationType<?>>> RELATION_TYPE_INIT_ACTION = RelationTypes.RELATION_TYPE_INIT_ACTION;

    private MetaTypes() {
    }

    static {
        RelationTypes.init(MetaTypes.class);
    }

    private static class ImmutableFlagType
    extends RelationType<Boolean>
    implements EventHandler<RelationEvent<?>> {
        private static final long serialVersionUID = 1L;

        public ImmutableFlagType() {
            super(RelationTypeModifier.FINAL);
        }

        @Override
        public void addRelation(Relatable rParent, Relation<Boolean> rRelation) {
            if (rRelation.getTarget() != Boolean.TRUE) {
                throw new IllegalArgumentException(this.getName() + " must always be set to TRUE");
            }
            super.addRelation(rParent, rRelation);
            for (Relation<?> rOtherRelation : rParent.getRelations(null)) {
                RelationType<?> rRelationType = rOtherRelation.getType();
                Object rTarget = rOtherRelation.getTarget();
                if (rTarget instanceof Collection) {
                    this.setCollectionImmutable(rParent, rRelationType, (Collection)rTarget);
                } else if (rTarget instanceof Map && rRelationType.getTargetType() == Map.class) {
                    this.setMapImmutable(rParent, rRelationType, (Map)rTarget);
                }
                if (rOtherRelation.hasFlag(IMMUTABLE)) continue;
                rOtherRelation.set(IMMUTABLE);
            }
            if (rParent instanceof Immutability) {
                ((Immutability)rParent).setImmutable();
            }
            EventDispatcher<RelationEvent<?>> rListeners = rParent.get(StandardTypes.RELATION_LISTENERS);
            rListeners.add(this);
            rListeners.setImmutable();
        }

        @Override
        public void handleEvent(RelationEvent<?> rEvent) {
            if (((Relatable)rEvent.getSource()).hasRelation(this)) {
                String sMessage = String.format("Could not %s %s; object is immutable: %s", new Object[]{rEvent.getType(), rEvent.getElement(), rEvent.getSource()});
                throw new UnsupportedOperationException(sMessage);
            }
        }

        private void setCollectionImmutable(Relatable rParent, RelationType<?> rRelationType, Collection<?> rCollection) {
            Class<?> rTargetType = rRelationType.getTargetType();
            if (rTargetType == List.class) {
                rCollection = Collections.unmodifiableList((List)rCollection);
            } else if (rTargetType == Set.class) {
                rCollection = Collections.unmodifiableSet((Set)rCollection);
            }
            RelationType<?> rCollectionType = rRelationType;
            rParent.set(rCollectionType, rCollection);
        }

        private void setMapImmutable(Relatable rParent, RelationType<?> rRelationType, Map<?, ?> rMap) {
            RelationType<?> rMapType = rRelationType;
            rParent.set(rMapType, Collections.unmodifiableMap(rMap));
        }
    }
}

