/*
 * Decompiled with CFR 0.152.
 */
package processing.a2d;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Build;
import android.view.SurfaceHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import processing.a2d.PSurfaceAndroid2D;
import processing.android.AppComponent;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PShapeSVG;
import processing.core.PSurface;
import processing.data.XML;

public class PGraphicsAndroid2D
extends PGraphics {
    public static boolean useBitmap = true;
    public Canvas canvas;
    boolean breakShape;
    float[] curveCoordX;
    float[] curveCoordY;
    float[] curveDrawX;
    float[] curveDrawY;
    protected static final int MATRIX_STACK_DEPTH = 32;
    protected float[][] transformStack = new float[32][6];
    public PMatrix2D transform = new PMatrix2D();
    protected Matrix transformMatrix = new Matrix();
    protected float[] transformArray = new float[9];
    int transformCount;
    Path path = new Path();
    RectF rect = new RectF();
    Paint fillPaint = new Paint();
    Paint strokePaint;
    Paint tintPaint;
    protected boolean sized;
    protected boolean changed;
    Rect imageImplSrcRect;
    RectF imageImplDstRect;
    float[] screenPoint;
    static int[] getset = new int[1];

    public PGraphicsAndroid2D() {
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.strokePaint = new Paint();
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.tintPaint = new Paint(2);
    }

    @Override
    public void surfaceChanged() {
        this.changed = true;
    }

    @Override
    public void setSize(int iwidth, int iheight) {
        this.sized = iwidth != this.width || iheight != this.height;
        super.setSize(iwidth, iheight);
    }

    @Override
    public void dispose() {
        if (this.bitmap != null) {
            this.bitmap.recycle();
        }
    }

    @Override
    public PSurface createSurface(AppComponent component, SurfaceHolder holder, boolean reset) {
        return new PSurfaceAndroid2D(this, component, holder);
    }

    @SuppressLint(value={"NewApi"})
    protected Canvas checkCanvas() {
        if (!(this.canvas != null && !this.sized || !useBitmap && this.primaryGraphics)) {
            if (this.bitmap == null || this.bitmap.getWidth() * this.bitmap.getHeight() < this.width * this.height || Build.VERSION.SDK_INT < 19) {
                if (this.bitmap != null) {
                    this.bitmap.recycle();
                }
                this.bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            } else {
                this.bitmap.reconfigure(this.width, this.height, this.bitmap.getConfig());
            }
            this.canvas = new Canvas(this.bitmap);
            this.sized = false;
        }
        this.restoreSurface();
        return this.canvas;
    }

    @Override
    public void beginDraw() {
        this.canvas = this.checkCanvas();
        this.checkSettings();
        this.resetMatrix();
        this.vertexCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void endDraw() {
        if (this.bitmap == null) {
            return;
        }
        if (this.primaryGraphics) {
            holder = this.parent.getSurface().getSurfaceHolder();
            if (holder != null) {
                screen = null;
                try {
                    screen = holder.lockCanvas(null);
                    if (screen == null) ** GOTO lbl27
                    screen.drawBitmap(this.bitmap, new Matrix(), null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (screen != null) {
                        try {
                            holder.unlockCanvasAndPost(screen);
                        }
                        catch (IllegalStateException var3_6) {
                        }
                        catch (IllegalArgumentException var3_7) {}
                    }
                }
            }
        } else {
            this.loadPixels();
        }
lbl27:
        // 5 sources

        this.setModified();
        super.updatePixels();
    }

    @Override
    public void beginShape(int kind) {
        this.shape = kind;
        this.vertexCount = 0;
        this.curveVertexCount = 0;
    }

    @Override
    public void texture(PImage image) {
        PGraphicsAndroid2D.showMethodWarning("texture");
    }

    @Override
    public void vertex(float x, float y) {
        if (this.shape == 20) {
            if (this.vertexCount == 0) {
                this.path.reset();
                this.path.moveTo(x, y);
                this.vertexCount = 1;
            } else if (this.breakShape) {
                this.path.moveTo(x, y);
                this.breakShape = false;
            } else {
                this.path.lineTo(x, y);
            }
        } else {
            this.curveVertexCount = 0;
            if (this.vertexCount == this.vertices.length) {
                float[][] temp = new float[this.vertexCount << 1][37];
                System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
                this.vertices = temp;
            }
            this.vertices[this.vertexCount][0] = x;
            this.vertices[this.vertexCount][1] = y;
            ++this.vertexCount;
            switch (this.shape) {
                case 3: {
                    break;
                }
                case 5: {
                    if (this.vertexCount % 2 != 0) break;
                    this.line(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                    this.vertexCount = 0;
                    break;
                }
                case 50: 
                case 51: {
                    if (this.vertexCount < 2) break;
                    this.line(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                    break;
                }
                case 9: {
                    if (this.vertexCount % 3 != 0) break;
                    this.triangle(this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                    this.vertexCount = 0;
                    break;
                }
                case 10: {
                    if (this.vertexCount < 3) break;
                    this.triangle(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y, this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                    break;
                }
                case 11: {
                    if (this.vertexCount < 3) break;
                    this.triangle(this.vertices[0][0], this.vertices[0][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                    break;
                }
                case 16: 
                case 17: {
                    if (this.vertexCount % 4 != 0) break;
                    this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                    this.vertexCount = 0;
                    break;
                }
                case 18: {
                    if (this.vertexCount < 4 || this.vertexCount % 2 != 0) break;
                    this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y, this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                }
            }
        }
    }

    @Override
    public void vertex(float x, float y, float z) {
        PGraphicsAndroid2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void vertex(float x, float y, float u, float v) {
        PGraphicsAndroid2D.showVariationWarning("vertex(x, y, u, v)");
    }

    @Override
    public void vertex(float x, float y, float z, float u, float v) {
        PGraphicsAndroid2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void breakShape() {
        this.breakShape = true;
    }

    @Override
    public void endShape(int mode) {
        if (this.shape == 3 && this.stroke && this.vertexCount > 0) {
            Matrix m = this.getMatrixImp();
            if (this.strokeWeight == 1.0f && m.isIdentity()) {
                if (this.screenPoint == null) {
                    this.screenPoint = new float[2];
                }
                for (int i = 0; i < this.vertexCount; ++i) {
                    this.screenPoint[0] = this.vertices[i][0];
                    this.screenPoint[1] = this.vertices[i][1];
                    m.mapPoints(this.screenPoint);
                    this.set(PApplet.round(this.screenPoint[0]), PApplet.round(this.screenPoint[1]), this.strokeColor);
                    float x = this.vertices[i][0];
                    float y = this.vertices[i][1];
                    this.set(PApplet.round(this.screenX(x, y)), PApplet.round(this.screenY(x, y)), this.strokeColor);
                }
            } else {
                float sw = this.strokeWeight / 2.0f;
                this.strokePaint.setStyle(Paint.Style.FILL);
                for (int i = 0; i < this.vertexCount; ++i) {
                    float x = this.vertices[i][0];
                    float y = this.vertices[i][1];
                    this.rect.set(x - sw, y - sw, x + sw, y + sw);
                    this.canvas.drawOval(this.rect, this.strokePaint);
                }
                this.strokePaint.setStyle(Paint.Style.STROKE);
            }
        } else if (this.shape == 20) {
            if (!this.path.isEmpty()) {
                if (mode == 2) {
                    this.path.close();
                }
                this.drawPath();
            }
        } else if (this.shape == 51 && this.vertexCount >= 2) {
            this.line(this.vertices[this.vertexCount - 1][0], this.vertices[this.vertexCount - 1][1], this.vertices[0][0], this.vertices[0][1]);
        }
        this.shape = 0;
    }

    @Override
    protected void clipImpl(float x1, float y1, float x2, float y2) {
        this.canvas.clipRect(x1, y1, x2, y2);
    }

    @Override
    public void noClip() {
        this.canvas.clipRect(0.0f, 0.0f, (float)this.width, (float)this.height, Region.Op.REPLACE);
    }

    @Override
    public void bezierVertex(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.bezierVertexCheck();
        this.path.cubicTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        PGraphicsAndroid2D.showDepthWarningXYZ("bezierVertex");
    }

    @Override
    public void quadraticVertex(float ctrlX, float ctrlY, float endX, float endY) {
        this.bezierVertexCheck();
        this.path.quadTo(ctrlX, ctrlY, endX, endY);
    }

    @Override
    public void quadraticVertex(float x2, float y2, float z2, float x4, float y4, float z4) {
        PGraphicsAndroid2D.showDepthWarningXYZ("quadVertex");
    }

    @Override
    protected void curveVertexCheck() {
        super.curveVertexCheck();
        if (this.curveCoordX == null) {
            this.curveCoordX = new float[4];
            this.curveCoordY = new float[4];
            this.curveDrawX = new float[4];
            this.curveDrawY = new float[4];
        }
    }

    @Override
    protected void curveVertexSegment(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.curveCoordX[0] = x1;
        this.curveCoordY[0] = y1;
        this.curveCoordX[1] = x2;
        this.curveCoordY[1] = y2;
        this.curveCoordX[2] = x3;
        this.curveCoordY[2] = y3;
        this.curveCoordX[3] = x4;
        this.curveCoordY[3] = y4;
        this.curveToBezierMatrix.mult(this.curveCoordX, this.curveDrawX);
        this.curveToBezierMatrix.mult(this.curveCoordY, this.curveDrawY);
        if (this.vertexCount == 0) {
            this.path.moveTo(this.curveDrawX[0], this.curveDrawY[0]);
            this.vertexCount = 1;
        }
        this.path.cubicTo(this.curveDrawX[1], this.curveDrawY[1], this.curveDrawX[2], this.curveDrawY[2], this.curveDrawX[3], this.curveDrawY[3]);
    }

    @Override
    public void curveVertex(float x, float y, float z) {
        PGraphicsAndroid2D.showDepthWarningXYZ("curveVertex");
    }

    @Override
    public void point(float x, float y) {
        this.beginShape(3);
        this.vertex(x, y);
        this.endShape();
    }

    @Override
    public void line(float x1, float y1, float x2, float y2) {
        if (this.stroke) {
            this.canvas.drawLine(x1, y1, x2, y2, this.strokePaint);
        }
    }

    @Override
    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.path.reset();
        this.path.moveTo(x1, y1);
        this.path.lineTo(x2, y2);
        this.path.lineTo(x3, y3);
        this.path.close();
        this.drawPath();
    }

    @Override
    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.path.reset();
        this.path.moveTo(x1, y1);
        this.path.lineTo(x2, y2);
        this.path.lineTo(x3, y3);
        this.path.lineTo(x4, y4);
        this.path.close();
        this.drawPath();
    }

    @Override
    protected void rectImpl(float x1, float y1, float x2, float y2) {
        if (this.fill) {
            this.canvas.drawRect(x1, y1, x2, y2, this.fillPaint);
        }
        if (this.stroke) {
            this.canvas.drawRect(x1, y1, x2, y2, this.strokePaint);
        }
    }

    @Override
    protected void ellipseImpl(float x, float y, float w, float h) {
        this.rect.set(x, y, x + w, y + h);
        if (this.fill) {
            this.canvas.drawOval(this.rect, this.fillPaint);
        }
        if (this.stroke) {
            this.canvas.drawOval(this.rect, this.strokePaint);
        }
    }

    @Override
    protected void arcImpl(float x, float y, float w, float h, float start, float stop, int mode) {
        if (stop - start >= (float)Math.PI * 2) {
            this.ellipseImpl(x, y, w, h);
        } else {
            start *= 57.295776f;
            stop *= 57.295776f;
            while (start < 0.0f) {
                start += 360.0f;
                stop += 360.0f;
            }
            if (start > stop) {
                float temp = start;
                start = stop;
                stop = temp;
            }
            float sweep = stop - start;
            this.rect.set(x, y, x + w, y + h);
            if (mode == 0) {
                if (this.fill) {
                    this.canvas.drawArc(this.rect, start, sweep, true, this.fillPaint);
                }
                if (this.stroke) {
                    this.canvas.drawArc(this.rect, start, sweep, false, this.strokePaint);
                }
            } else if (mode == 1) {
                if (this.fill) {
                    this.canvas.drawArc(this.rect, start, sweep, false, this.fillPaint);
                    this.canvas.drawArc(this.rect, start, sweep, false, this.strokePaint);
                }
                if (this.stroke) {
                    this.canvas.drawArc(this.rect, start, sweep, false, this.strokePaint);
                }
            } else if (mode == 2) {
                float endAngle = start + sweep;
                float halfRectWidth = this.rect.width() / 2.0f;
                float halfRectHeight = this.rect.height() / 2.0f;
                float centerX = this.rect.centerX();
                float centerY = this.rect.centerY();
                float startX = (float)((double)halfRectWidth * Math.cos(Math.toRadians(start))) + centerX;
                float startY = (float)((double)halfRectHeight * Math.sin(Math.toRadians(start))) + centerY;
                float endX = (float)((double)halfRectWidth * Math.cos(Math.toRadians(endAngle))) + centerX;
                float endY = (float)((double)halfRectHeight * Math.sin(Math.toRadians(endAngle))) + centerY;
                if (this.fill) {
                    this.canvas.drawArc(this.rect, start, sweep, false, this.fillPaint);
                    this.canvas.drawArc(this.rect, start, sweep, false, this.strokePaint);
                    this.canvas.drawLine(startX, startY, endX, endY, this.strokePaint);
                }
                if (this.stroke) {
                    this.canvas.drawArc(this.rect, start, sweep, false, this.strokePaint);
                    this.canvas.drawLine(startX, startY, endX, endY, this.strokePaint);
                }
            } else if (mode == 3) {
                if (this.fill) {
                    this.canvas.drawArc(this.rect, start, sweep, true, this.fillPaint);
                }
                if (this.stroke) {
                    this.canvas.drawArc(this.rect, start, sweep, true, this.strokePaint);
                }
            }
        }
    }

    protected void drawPath() {
        if (this.fill) {
            this.canvas.drawPath(this.path, this.fillPaint);
        }
        if (this.stroke) {
            this.canvas.drawPath(this.path, this.strokePaint);
        }
    }

    @Override
    public void box(float w, float h, float d) {
        PGraphicsAndroid2D.showMethodWarning("box");
    }

    @Override
    public void sphere(float r) {
        PGraphicsAndroid2D.showMethodWarning("sphere");
    }

    @Override
    public void bezierDetail(int detail) {
    }

    @Override
    public void curveDetail(int detail) {
    }

    @Override
    public void smooth(int quality) {
        super.smooth(quality);
        this.strokePaint.setAntiAlias(true);
        this.fillPaint.setAntiAlias(true);
    }

    @Override
    public void noSmooth() {
        super.noSmooth();
        this.strokePaint.setAntiAlias(false);
        this.fillPaint.setAntiAlias(false);
    }

    @Override
    protected void imageImpl(PImage src, float x1, float y1, float x2, float y2, int u1, int v1, int u2, int v2) {
        Bitmap bitmap = (Bitmap)src.getNative();
        if (bitmap != null && bitmap.isRecycled()) {
            bitmap = null;
        }
        if (bitmap == null && src.format == 4) {
            bitmap = Bitmap.createBitmap((int)src.width, (int)src.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            int[] px = new int[src.pixels.length];
            for (int i = 0; i < px.length; ++i) {
                px[i] = src.pixels[i] << 24 | 0xFFFFFF;
            }
            bitmap.setPixels(px, 0, src.width, 0, 0, src.width, src.height);
            this.modified = false;
            src.setNative(bitmap);
        }
        if (bitmap == null || src.width != bitmap.getWidth() || src.height != bitmap.getHeight()) {
            if (bitmap != null) {
                bitmap.recycle();
            }
            bitmap = Bitmap.createBitmap((int)src.width, (int)src.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.modified = true;
            src.setNative(bitmap);
        }
        if (src.isModified()) {
            if (!bitmap.isMutable()) {
                bitmap.recycle();
                bitmap = Bitmap.createBitmap((int)src.width, (int)src.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                src.setNative(bitmap);
            }
            if (src.pixels != null) {
                bitmap.setPixels(src.pixels, 0, src.width, 0, 0, src.width, src.height);
            }
            src.setModified(false);
        }
        if (this.imageImplSrcRect == null) {
            this.imageImplSrcRect = new Rect(u1, v1, u2, v2);
            this.imageImplDstRect = new RectF(x1, y1, x2, y2);
        } else {
            this.imageImplSrcRect.set(u1, v1, u2, v2);
            this.imageImplDstRect.set(x1, y1, x2, y2);
        }
        this.canvas.drawBitmap(bitmap, this.imageImplSrcRect, this.imageImplDstRect, this.tint ? this.tintPaint : null);
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        Activity activity = this.parent.getSurface().getActivity();
        if (activity == null) {
            return;
        }
        ActivityManager activityManager = (ActivityManager)activity.getSystemService("activity");
        activityManager.getMemoryInfo(mi);
        if (mi.lowMemory) {
            bitmap.recycle();
            src.setNative(null);
        }
    }

    @Override
    public PShape loadShape(String filename) {
        String extension = PApplet.getExtension(filename);
        PShapeSVG svg = null;
        if (extension.equals("svg")) {
            svg = new PShapeSVG(this.parent.loadXML(filename));
        } else if (extension.equals("svgz")) {
            try {
                GZIPInputStream input = new GZIPInputStream(this.parent.createInput(filename));
                XML xml = new XML(input);
                svg = new PShapeSVG(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            PGraphics.showWarning("Unsupported format");
        }
        return svg;
    }

    @Override
    public void textFont(PFont which) {
        super.textFont(which);
        this.fillPaint.setTypeface((Typeface)which.getNative());
        this.fillPaint.setTextSize((float)which.getDefaultSize());
    }

    @Override
    public void textFont(PFont which, float size) {
        super.textFont(which, size);
        this.fillPaint.setTypeface((Typeface)which.getNative());
        this.fillPaint.setTextSize(size);
    }

    @Override
    protected boolean textModeCheck(int mode) {
        return mode == 4;
    }

    @Override
    public void textSize(float size) {
        Typeface font;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textSize", size);
        }
        if ((font = (Typeface)this.textFont.getNative()) != null) {
            this.fillPaint.setTextSize(size);
        }
        this.handleTextSize(size);
    }

    protected void beginTextScreenMode() {
        this.loadPixels();
    }

    protected void endTextScreenMode() {
        this.updatePixels();
    }

    @Override
    protected float textWidthImpl(char[] buffer, int start, int stop) {
        Typeface font = (Typeface)this.textFont.getNative();
        if (font == null) {
            return super.textWidthImpl(buffer, start, stop);
        }
        int length = stop - start;
        return this.fillPaint.measureText(buffer, start, length);
    }

    @Override
    protected void textLineImpl(char[] buffer, int start, int stop, float x, float y) {
        Typeface font = (Typeface)this.textFont.getNative();
        if (font == null) {
            PGraphicsAndroid2D.showWarning("Inefficient font rendering: use createFont() with a TTF/OTF instead of loadFont().");
            super.textLineImpl(buffer, start, stop, x, y);
            return;
        }
        this.fillPaint.setAntiAlias(this.textFont.isSmooth());
        int length = stop - start;
        this.canvas.drawText(buffer, start, length, x, y, this.fillPaint);
        this.fillPaint.setAntiAlias(0 < this.smooth);
    }

    @Override
    public void pushMatrix() {
        if (this.transformCount == this.transformStack.length) {
            throw new RuntimeException("pushMatrix() cannot use push more than " + this.transformStack.length + " times");
        }
        this.transform.get(this.transformStack[this.transformCount]);
        ++this.transformCount;
    }

    @Override
    public void popMatrix() {
        if (this.transformCount == 0) {
            throw new RuntimeException("missing a popMatrix() to go with that pushMatrix()");
        }
        --this.transformCount;
        this.transform.set(this.transformStack[this.transformCount]);
        this.updateTransformMatrix();
        this.canvas.setMatrix(this.transformMatrix);
    }

    @Override
    public void translate(float tx, float ty) {
        this.transform.translate(tx, ty);
        this.canvas.translate(tx, ty);
    }

    @Override
    public void rotate(float angle) {
        this.transform.rotate(angle);
        this.canvas.rotate(angle * 57.295776f);
    }

    @Override
    public void rotateX(float angle) {
        PGraphicsAndroid2D.showDepthWarning("rotateX");
    }

    @Override
    public void rotateY(float angle) {
        PGraphicsAndroid2D.showDepthWarning("rotateY");
    }

    @Override
    public void rotateZ(float angle) {
        PGraphicsAndroid2D.showDepthWarning("rotateZ");
    }

    @Override
    public void rotate(float angle, float vx, float vy, float vz) {
        PGraphicsAndroid2D.showVariationWarning("rotate");
    }

    @Override
    public void scale(float s) {
        this.transform.scale(s, s);
        this.canvas.scale(s, s);
    }

    @Override
    public void scale(float sx, float sy) {
        this.transform.scale(sx, sy);
        this.canvas.scale(sx, sy);
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        PGraphicsAndroid2D.showDepthWarningXYZ("scale");
    }

    @Override
    public void shearX(float angle) {
        float t = (float)Math.tan(angle);
        this.transform.apply(1.0f, t, 0.0f, 0.0f, 1.0f, 0.0f);
        this.canvas.skew(t, 0.0f);
    }

    @Override
    public void shearY(float angle) {
        float t = (float)Math.tan(angle);
        this.transform.apply(1.0f, 0.0f, 0.0f, t, 1.0f, 0.0f);
        this.canvas.skew(0.0f, t);
    }

    @Override
    public void resetMatrix() {
        this.transform.reset();
        this.canvas.setMatrix(null);
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.transform.apply(n00, n01, n02, n10, n11, n12);
        this.updateTransformMatrix();
        this.canvas.concat(this.transformMatrix);
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        PGraphicsAndroid2D.showVariationWarning("applyMatrix");
    }

    @Override
    public PMatrix getMatrix() {
        return this.getMatrix((PMatrix2D)null);
    }

    @Override
    public PMatrix2D getMatrix(PMatrix2D target) {
        if (target == null) {
            target = new PMatrix2D();
        }
        target.set(this.transform);
        return target;
    }

    @Override
    public PMatrix3D getMatrix(PMatrix3D target) {
        PGraphicsAndroid2D.showVariationWarning("getMatrix");
        return target;
    }

    @Override
    public void setMatrix(PMatrix2D source) {
        this.transform.set(source);
        this.updateTransformMatrix();
        this.canvas.setMatrix(this.transformMatrix);
    }

    @Override
    public void setMatrix(PMatrix3D source) {
        PGraphicsAndroid2D.showVariationWarning("setMatrix");
    }

    @Override
    public void printMatrix() {
        this.getMatrix((PMatrix2D)null).print();
    }

    protected Matrix getMatrixImp() {
        Matrix m = new Matrix();
        this.updateTransformMatrix();
        m.set(this.transformMatrix);
        return m;
    }

    public void updateTransformMatrix() {
        this.transformArray[0] = this.transform.m00;
        this.transformArray[1] = this.transform.m01;
        this.transformArray[2] = this.transform.m02;
        this.transformArray[3] = this.transform.m10;
        this.transformArray[4] = this.transform.m11;
        this.transformArray[5] = this.transform.m12;
        this.transformArray[6] = 0.0f;
        this.transformArray[7] = 0.0f;
        this.transformArray[8] = 1.0f;
        this.transformMatrix.setValues(this.transformArray);
    }

    @Override
    public float screenX(float x, float y) {
        if (this.screenPoint == null) {
            this.screenPoint = new float[2];
        }
        this.screenPoint[0] = x;
        this.screenPoint[1] = y;
        this.getMatrixImp().mapPoints(this.screenPoint);
        return this.screenPoint[0];
    }

    @Override
    public float screenY(float x, float y) {
        if (this.screenPoint == null) {
            this.screenPoint = new float[2];
        }
        this.screenPoint[0] = x;
        this.screenPoint[1] = y;
        this.getMatrixImp().mapPoints(this.screenPoint);
        return this.screenPoint[1];
    }

    @Override
    public float screenX(float x, float y, float z) {
        PGraphicsAndroid2D.showDepthWarningXYZ("screenX");
        return 0.0f;
    }

    @Override
    public float screenY(float x, float y, float z) {
        PGraphicsAndroid2D.showDepthWarningXYZ("screenY");
        return 0.0f;
    }

    @Override
    public float screenZ(float x, float y, float z) {
        PGraphicsAndroid2D.showDepthWarningXYZ("screenZ");
        return 0.0f;
    }

    @Override
    public void strokeCap(int cap) {
        super.strokeCap(cap);
        if (this.strokeCap == 2) {
            this.strokePaint.setStrokeCap(Paint.Cap.ROUND);
        } else if (this.strokeCap == 4) {
            this.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
        } else {
            this.strokePaint.setStrokeCap(Paint.Cap.BUTT);
        }
    }

    @Override
    public void strokeJoin(int join) {
        super.strokeJoin(join);
        if (this.strokeJoin == 8) {
            this.strokePaint.setStrokeJoin(Paint.Join.MITER);
        } else if (this.strokeJoin == 2) {
            this.strokePaint.setStrokeJoin(Paint.Join.ROUND);
        } else {
            this.strokePaint.setStrokeJoin(Paint.Join.BEVEL);
        }
    }

    @Override
    public void strokeWeight(float weight) {
        super.strokeWeight(weight);
        this.strokePaint.setStrokeWidth(weight);
    }

    @Override
    protected void strokeFromCalc() {
        super.strokeFromCalc();
        this.strokePaint.setColor(this.strokeColor);
        this.strokePaint.setShader(null);
    }

    @Override
    protected void tintFromCalc() {
        super.tintFromCalc();
        this.tintPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.tintColor, PorterDuff.Mode.MULTIPLY));
    }

    @Override
    protected void fillFromCalc() {
        super.fillFromCalc();
        this.fillPaint.setColor(this.fillColor);
        this.fillPaint.setShader(null);
    }

    @Override
    public void backgroundImpl() {
        this.canvas.drawColor(this.backgroundColor);
    }

    @Override
    public void beginRaw(PGraphics recorderRaw) {
        PGraphicsAndroid2D.showMethodWarning("beginRaw");
    }

    @Override
    public void endRaw() {
        PGraphicsAndroid2D.showMethodWarning("endRaw");
    }

    @Override
    public void loadPixels() {
        if (this.bitmap == null) {
            throw new RuntimeException("The pixels array is not available in this renderer withouth a backing bitmap");
        }
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
        }
        this.bitmap.getPixels(this.pixels, 0, this.width, 0, 0, this.width, this.height);
    }

    @Override
    public void updatePixels() {
        if (this.bitmap == null) {
            throw new RuntimeException("The pixels array is not available in this renderer withouth a backing bitmap");
        }
        this.bitmap.setPixels(this.pixels, 0, this.width, 0, 0, this.width, this.height);
    }

    @Override
    public void updatePixels(int x, int y, int c, int d) {
        if (x != 0 || y != 0 || c != this.width || d != this.height) {
            PGraphicsAndroid2D.showVariationWarning("updatePixels(x, y, w, h)");
        }
        this.updatePixels();
    }

    @Override
    public void resize(int wide, int high) {
        PGraphicsAndroid2D.showMethodWarning("resize");
    }

    @Override
    protected void saveState() {
        super.saveState();
        Context context = this.parent.getContext();
        if (context == null || this.bitmap == null || this.parent.getSurface().getComponent().isService()) {
            return;
        }
        try {
            this.restoreWidth = this.pixelWidth;
            this.restoreHeight = this.pixelHeight;
            int size = this.bitmap.getHeight() * this.bitmap.getRowBytes();
            ByteBuffer restoreBitmap = ByteBuffer.allocate(size);
            this.bitmap.copyPixelsToBuffer((Buffer)restoreBitmap);
            File cacheDir = context.getCacheDir();
            File cacheFile = File.createTempFile("processing", "pixels", cacheDir);
            this.restoreFilename = cacheFile.getAbsolutePath();
            FileOutputStream stream = new FileOutputStream(cacheFile);
            ObjectOutputStream dout = new ObjectOutputStream(stream);
            byte[] array = new byte[size];
            restoreBitmap.rewind();
            restoreBitmap.get(array);
            dout.writeObject(array);
            dout.flush();
            stream.getFD().sync();
            stream.close();
        }
        catch (Exception ex) {
            PGraphics.showWarning("Could not save screen contents to cache");
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void restoreSurface() {
        if (this.changed) {
            this.changed = false;
            if (this.restoreFilename != null && this.restoreWidth == this.pixelWidth && this.restoreHeight == this.pixelHeight) {
                this.restoreCount = 1;
            }
        } else if (this.restoreCount > 0) {
            --this.restoreCount;
            if (this.restoreCount == 0) {
                Context context = this.parent.getContext();
                if (context == null) {
                    return;
                }
                try {
                    File cacheFile = new File(this.restoreFilename);
                    FileInputStream inStream = new FileInputStream(cacheFile);
                    ObjectInputStream din = new ObjectInputStream(inStream);
                    byte[] array = (byte[])din.readObject();
                    ByteBuffer restoreBitmap = ByteBuffer.wrap(array);
                    if (restoreBitmap.capacity() == this.bitmap.getHeight() * this.bitmap.getRowBytes()) {
                        restoreBitmap.rewind();
                        this.bitmap.copyPixelsFromBuffer((Buffer)restoreBitmap);
                    }
                    inStream.close();
                    cacheFile.delete();
                }
                catch (Exception ex) {
                    PGraphics.showWarning("Could not restore screen contents from cache");
                    ex.printStackTrace();
                }
                finally {
                    this.restoreFilename = null;
                    this.restoreWidth = -1;
                    this.restoreHeight = -1;
                    this.restoredSurface = true;
                }
            }
        }
        super.restoreSurface();
    }

    @Override
    public int get(int x, int y) {
        if (this.bitmap == null || x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return 0;
        }
        return this.bitmap.getPixel(x, y);
    }

    @Override
    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    @Override
    public void set(int x, int y, int argb) {
        if (this.bitmap == null || x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return;
        }
        this.bitmap.setPixel(x, y, argb);
    }

    @Override
    public void set(int x, int y, PImage src) {
        if (src.format == 4) {
            throw new RuntimeException("set() not available for ALPHA images");
        }
        Bitmap bitmap = (Bitmap)src.getNative();
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)src.width, (int)src.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            src.setNative(bitmap);
            src.setModified();
        }
        if (src.width != bitmap.getWidth() || src.height != bitmap.getHeight()) {
            bitmap.recycle();
            bitmap = Bitmap.createBitmap((int)src.width, (int)src.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            src.setNative(bitmap);
            src.setModified();
        }
        if (src.isModified()) {
            if (!bitmap.isMutable()) {
                bitmap.recycle();
                bitmap = Bitmap.createBitmap((int)src.width, (int)src.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.setNative(bitmap);
            }
            bitmap.setPixels(src.pixels, 0, src.width, 0, 0, src.width, src.height);
            src.setModified(false);
        }
        this.pushMatrix();
        this.canvas.setMatrix(null);
        this.canvas.drawBitmap(bitmap, (float)x, (float)y, null);
        this.popMatrix();
    }

    @Override
    public void mask(int[] alpha) {
        PGraphicsAndroid2D.showMethodWarning("mask");
    }

    @Override
    public void mask(PImage alpha) {
        PGraphicsAndroid2D.showMethodWarning("mask");
    }

    @Override
    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        if (this.bitmap == null) {
            throw new RuntimeException("The pixels array is not available in this renderer withouth a backing bitmap");
        }
        this.rect.set((float)sx, (float)sy, (float)(sx + sw), (float)(sy + sh));
        Rect src = new Rect(dx, dy, dx + dw, dy + dh);
        this.canvas.drawBitmap(this.bitmap, src, this.rect, null);
    }
}

