/*
 * Decompiled with CFR 0.152.
 */
package processing.a2d;

import android.graphics.LinearGradient;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import processing.a2d.PGraphicsAndroid2D;
import processing.core.PGraphics;
import processing.core.PShapeSVG;
import processing.data.XML;

public class PShapeAndroid2D
extends PShapeSVG {
    protected Shader strokeGradientPaint;
    protected Shader fillGradientPaint;

    public PShapeAndroid2D(XML svg) {
        super(svg);
    }

    public PShapeAndroid2D(PShapeSVG parent, XML properties, boolean parseKids) {
        super(parent, properties, parseKids);
    }

    @Override
    protected void setParent(PShapeSVG parent) {
        super.setParent(parent);
        if (parent instanceof PShapeAndroid2D) {
            PShapeAndroid2D pj = (PShapeAndroid2D)parent;
            this.fillGradientPaint = pj.fillGradientPaint;
            this.strokeGradientPaint = pj.strokeGradientPaint;
        } else {
            this.fillGradientPaint = null;
            this.strokeGradientPaint = null;
        }
    }

    @Override
    protected PShapeSVG createShape(PShapeSVG parent, XML properties, boolean parseKids) {
        return new PShapeAndroid2D(parent, properties, parseKids);
    }

    protected Shader calcGradientPaint(PShapeSVG.Gradient gradient) {
        int[] colors = new int[gradient.count];
        int opacityMask = (int)(this.opacity * 255.0f) << 24;
        for (int i = 0; i < gradient.count; ++i) {
            colors[i] = opacityMask | gradient.color[i] & 0xFFFFFF;
        }
        if (gradient instanceof PShapeSVG.LinearGradient) {
            PShapeSVG.LinearGradient grad = (PShapeSVG.LinearGradient)gradient;
            return new LinearGradient(grad.x1, grad.y1, grad.x2, grad.y2, colors, grad.offset, Shader.TileMode.CLAMP);
        }
        if (gradient instanceof PShapeSVG.RadialGradient) {
            PShapeSVG.RadialGradient grad = (PShapeSVG.RadialGradient)gradient;
            return new RadialGradient(grad.cx, grad.cy, grad.r, colors, grad.offset, Shader.TileMode.CLAMP);
        }
        return null;
    }

    @Override
    protected void styles(PGraphics g) {
        super.styles(g);
        if (g instanceof PGraphicsAndroid2D) {
            PGraphicsAndroid2D gg = (PGraphicsAndroid2D)g;
            if (this.strokeGradient != null) {
                if (this.strokeGradientPaint == null) {
                    this.strokeGradientPaint = this.calcGradientPaint(this.strokeGradient);
                }
                gg.strokePaint.setShader(this.strokeGradientPaint);
            }
            if (this.fillGradient != null) {
                if (this.fillGradientPaint == null) {
                    this.fillGradientPaint = this.calcGradientPaint(this.fillGradient);
                }
                gg.fillPaint.setShader(this.fillGradientPaint);
            }
        }
    }
}

