/*
 * Decompiled with CFR 0.152.
 */
package processing.android;

import android.annotation.SuppressLint;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;

public class CompatUtils {
    private static final AtomicInteger nextId = new AtomicInteger(15000000);

    public static void getDisplayParams(Display display, DisplayMetrics metrics, Point size) {
        if (17 <= Build.VERSION.SDK_INT) {
            display.getRealMetrics(metrics);
            display.getRealSize(size);
        }
        if (14 <= Build.VERSION.SDK_INT) {
            display.getMetrics(metrics);
            try {
                size.x = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                size.y = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception e) {
                display.getSize(size);
            }
        } else {
            display.getMetrics(metrics);
            display.getSize(size);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static int getUniqueViewId() {
        int newValue;
        int result;
        if (17 <= Build.VERSION.SDK_INT) {
            return View.generateViewId();
        }
        do {
            if ((newValue = (result = nextId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!nextId.compareAndSet(result, newValue));
        return result;
    }

    @SuppressLint(value={"NewApi"})
    public static Charset getCharsetUTF8() {
        if (19 <= Build.VERSION.SDK_INT) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName("UTF-8");
    }
}

