/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.mobile;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.webkit.URLUtil;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.prebid.mobile.CacheManager;
import org.prebid.mobile.ImpressionTracker;
import org.prebid.mobile.ImpressionTrackerListener;
import org.prebid.mobile.PrebidNativeAdEventListener;
import org.prebid.mobile.VisibilityDetector;

public class PrebidNativeAd {
    private String title;
    private String description;
    private String iconUrl;
    private String imageUrl;
    private String cta;
    private String sponsoredBy;
    private String clickUrl;
    private ArrayList<String> imp_trackers;
    private VisibilityDetector visibilityDetector;
    private boolean expired;
    private View registeredView;
    private PrebidNativeAdEventListener listener;
    private ArrayList<ImpressionTracker> impressionTrackers;

    static PrebidNativeAd create(String cacheId) {
        String content = CacheManager.get(cacheId);
        if (!TextUtils.isEmpty((CharSequence)content)) {
            try {
                JSONArray eventtrackers;
                JSONObject link;
                JSONObject details = new JSONObject(content);
                String admStr = details.getString("adm");
                JSONObject adm = new JSONObject(admStr);
                JSONArray asset = adm.getJSONArray("assets");
                final PrebidNativeAd ad = new PrebidNativeAd();
                CacheManager.registerCacheExpiryListener(cacheId, new CacheManager.CacheExpiryListener(){

                    @Override
                    public void onCacheExpired() {
                        if (ad.registeredView == null) {
                            if (ad.listener != null) {
                                ad.listener.onAdExpired();
                            }
                            ad.expired = true;
                            if (ad.visibilityDetector != null) {
                                ad.visibilityDetector.destroy();
                                ad.visibilityDetector = null;
                            }
                            ad.impressionTrackers = null;
                            ad.listener = null;
                        }
                    }
                });
                for (int i = 0; i < asset.length(); ++i) {
                    JSONObject img;
                    JSONObject title;
                    JSONObject adObject = asset.getJSONObject(i);
                    if (adObject.has("title") && (title = adObject.getJSONObject("title")).has("text")) {
                        ad.setTitle(title.getString("text"));
                    }
                    if (adObject.has("data")) {
                        JSONObject data = adObject.getJSONObject("data");
                        if (data.optInt("type") == 1) {
                            ad.setSponsoredBy(data.getString("value"));
                        } else if (data.optInt("type") == 2) {
                            ad.setDescription(data.getString("value"));
                        } else if (data.optInt("type") == 12) {
                            ad.setCallToAction(data.getString("value"));
                        }
                    }
                    if (!adObject.has("img")) continue;
                    if (adObject.optInt("id") == 1) {
                        img = adObject.getJSONObject("img");
                        if (!img.has("url")) continue;
                        ad.setIconUrl(img.getString("url"));
                        continue;
                    }
                    if (adObject.optInt("id") != 2 || !(img = adObject.getJSONObject("img")).has("url")) continue;
                    ad.setImageUrl(img.getString("url"));
                }
                if (adm.has("link") && (link = adm.getJSONObject("link")).has("url")) {
                    String url = link.getString("url");
                    if (url.contains("{AUCTION_PRICE}") && details.has("price")) {
                        url = url.replace("{AUCTION_PRICE}", details.getString("price"));
                    }
                    ad.setClickUrl(url);
                }
                if (adm.has("eventtrackers") && (eventtrackers = adm.getJSONArray("eventtrackers")).length() > 0) {
                    ad.imp_trackers = new ArrayList();
                    for (int count = 0; count < eventtrackers.length(); ++count) {
                        JSONObject eventtracker = eventtrackers.getJSONObject(count);
                        if (!eventtracker.has("url")) continue;
                        String impUrl = eventtracker.getString("url");
                        if (impUrl.contains("{AUCTION_PRICE}") && details.has("price")) {
                            impUrl = impUrl.replace("{AUCTION_PRICE}", details.getString("price"));
                        }
                        ad.imp_trackers.add(impUrl);
                    }
                }
                return ad.isValid() ? ad : null;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean isValid() {
        return URLUtil.isValidUrl((String)this.clickUrl) && !TextUtils.isEmpty((CharSequence)this.title) && !TextUtils.isEmpty((CharSequence)this.description) && URLUtil.isValidUrl((String)this.iconUrl) && URLUtil.isValidUrl((String)this.imageUrl) && !TextUtils.isEmpty((CharSequence)this.cta);
    }

    private PrebidNativeAd() {
    }

    private void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    private void setTitle(String title) {
        this.title = title;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    private void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    private void setCallToAction(String cta) {
        this.cta = cta;
    }

    private void setSponsoredBy(String sponsoredBy) {
        this.sponsoredBy = sponsoredBy;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getCallToAction() {
        return this.cta;
    }

    public String getSponsoredBy() {
        return this.sponsoredBy;
    }

    public boolean registerView(View view, final PrebidNativeAdEventListener listener) {
        if (!this.expired && view != null) {
            this.listener = listener;
            this.visibilityDetector = VisibilityDetector.create(view);
            if (this.visibilityDetector == null) {
                return false;
            }
            this.impressionTrackers = new ArrayList(this.imp_trackers.size());
            for (String url : this.imp_trackers) {
                ImpressionTracker impressionTracker = ImpressionTracker.create(url, this.visibilityDetector, view.getContext(), new ImpressionTrackerListener(){

                    @Override
                    public void onImpressionTrackerFired() {
                        if (listener != null) {
                            listener.onAdImpression();
                        }
                    }
                });
                this.impressionTrackers.add(impressionTracker);
            }
            this.registeredView = view;
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PrebidNativeAd.this.handleClick(v, listener);
                }
            });
            return true;
        }
        return false;
    }

    public boolean registerViewList(View container, List<View> viewList, final PrebidNativeAdEventListener listener) {
        if (container == null || viewList == null || viewList.isEmpty()) {
            return false;
        }
        if (!this.expired && container != null) {
            this.listener = listener;
            this.visibilityDetector = VisibilityDetector.create(container);
            if (this.visibilityDetector == null) {
                return false;
            }
            this.impressionTrackers = new ArrayList(this.imp_trackers.size());
            for (String url : this.imp_trackers) {
                ImpressionTracker impressionTracker = ImpressionTracker.create(url, this.visibilityDetector, container.getContext(), new ImpressionTrackerListener(){

                    @Override
                    public void onImpressionTrackerFired() {
                        if (listener != null) {
                            listener.onAdImpression();
                        }
                    }
                });
                this.impressionTrackers.add(impressionTracker);
            }
            this.registeredView = container;
            container.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PrebidNativeAd.this.handleClick(v, listener);
                }
            });
            if (viewList != null && viewList.size() > 0) {
                for (View views : viewList) {
                    views.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            PrebidNativeAd.this.handleClick(v, listener);
                        }
                    });
                }
            }
            return true;
        }
        return false;
    }

    protected boolean registerPrebidNativeAdEventListener(PrebidNativeAdEventListener listener) {
        this.listener = listener;
        return true;
    }

    private boolean handleClick(View v, PrebidNativeAdEventListener listener) {
        if (this.clickUrl == null || this.clickUrl.isEmpty()) {
            return false;
        }
        if (this.openNativeIntent(this.clickUrl, v.getContext())) {
            listener.onAdClicked();
            return true;
        }
        return false;
    }

    private boolean openNativeIntent(String url, Context context) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        intent.setFlags(0x10000000);
        try {
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
    }
}

